/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.mockito.Mockito;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.util.reflection.GenericMetadataSupport;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.invocation.Location;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object defaultReturnValue = this.delegate.answer(invocation);
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        Class<?> type = invocation.getMethod().getReturnType();
        Type returnType = invocation.getMethod().getGenericReturnType();
        if (returnType instanceof TypeVariable && (type = this.findTypeFromGeneric(invocation, (TypeVariable)returnType)) != null) {
            defaultReturnValue = this.delegateChains(type);
        }
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        if (type != null && !type.isPrimitive() && !Modifier.isFinal(type.getModifiers())) {
            LocationImpl location = new LocationImpl();
            return Mockito.mock(type, new ThrowsSmartNullPointer(invocation, location));
        }
        return null;
    }

    private Object delegateChains(Class<?> type) {
        ReturnsEmptyValues returnsEmptyValues = new ReturnsEmptyValues();
        Object result = returnsEmptyValues.returnValueFor(type);
        if (result == null) {
            for (Class<?> emptyValueForClass = type; emptyValueForClass != null && result == null; emptyValueForClass = emptyValueForClass.getSuperclass()) {
                Class<?> clazz;
                Class<?>[] classes;
                Class<?>[] classArray = classes = emptyValueForClass.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (result = returnsEmptyValues.returnValueFor(clazz = classArray[i])) == null; ++i) {
                }
            }
        }
        if (result == null) {
            result = new ReturnsMoreEmptyValues().returnValueFor(type);
        }
        return result;
    }

    private Class<?> findTypeFromGeneric(InvocationOnMock invocation, TypeVariable returnType) {
        MockCreationSettings<Object> mockSettings = MockUtil.getMockHandler(invocation.getMock()).getMockSettings();
        GenericMetadataSupport returnTypeSupport = GenericMetadataSupport.inferFrom(mockSettings.getTypeToMock()).resolveGenericReturnType(invocation.getMethod());
        Class<?> rawType = returnTypeSupport.rawType();
        if (rawType == Object.class) {
            return this.findTypeFromGenericInArguments(invocation, returnType);
        }
        return rawType;
    }

    private Class<?> findTypeFromGenericInArguments(InvocationOnMock invocation, TypeVariable returnType) {
        Type[] parameterTypes = invocation.getMethod().getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type argType = parameterTypes[i];
            if (returnType.equals(argType)) {
                return invocation.getArgument(i).getClass();
            }
            if (!(argType instanceof GenericArrayType) || !returnType.equals(argType = ((GenericArrayType)argType).getGenericComponentType())) continue;
            return invocation.getArgument(i).getClass();
        }
        return null;
    }

    private static class ThrowsSmartNullPointer
    implements Answer {
        private final InvocationOnMock unstubbedInvocation;
        private final Location location;

        public ThrowsSmartNullPointer(InvocationOnMock unstubbedInvocation, Location location) {
            this.unstubbedInvocation = unstubbedInvocation;
            this.location = location;
        }

        public Object answer(InvocationOnMock currentInvocation) throws Throwable {
            if (ObjectMethodsGuru.isToStringMethod(currentInvocation.getMethod())) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.unstubbedInvocation.toString();
            }
            throw Reporter.smartNullPointerException(this.unstubbedInvocation.toString(), this.location);
        }
    }
}

