/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.ConnectCommandHandler;
import org.mockftpserver.core.command.ReplyTextBundleUtil;
import org.mockftpserver.core.command.UnsupportedCommandHandler;
import org.mockftpserver.core.server.AbstractFtpServer;
import org.mockftpserver.fake.ServerConfiguration;
import org.mockftpserver.fake.ServerConfigurationAware;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.command.AborCommandHandler;
import org.mockftpserver.fake.command.AcctCommandHandler;
import org.mockftpserver.fake.command.AlloCommandHandler;
import org.mockftpserver.fake.command.AppeCommandHandler;
import org.mockftpserver.fake.command.CdupCommandHandler;
import org.mockftpserver.fake.command.CwdCommandHandler;
import org.mockftpserver.fake.command.DeleCommandHandler;
import org.mockftpserver.fake.command.EprtCommandHandler;
import org.mockftpserver.fake.command.EpsvCommandHandler;
import org.mockftpserver.fake.command.HelpCommandHandler;
import org.mockftpserver.fake.command.ListCommandHandler;
import org.mockftpserver.fake.command.MkdCommandHandler;
import org.mockftpserver.fake.command.ModeCommandHandler;
import org.mockftpserver.fake.command.NlstCommandHandler;
import org.mockftpserver.fake.command.NoopCommandHandler;
import org.mockftpserver.fake.command.PassCommandHandler;
import org.mockftpserver.fake.command.PasvCommandHandler;
import org.mockftpserver.fake.command.PortCommandHandler;
import org.mockftpserver.fake.command.PwdCommandHandler;
import org.mockftpserver.fake.command.QuitCommandHandler;
import org.mockftpserver.fake.command.ReinCommandHandler;
import org.mockftpserver.fake.command.RestCommandHandler;
import org.mockftpserver.fake.command.RetrCommandHandler;
import org.mockftpserver.fake.command.RmdCommandHandler;
import org.mockftpserver.fake.command.RnfrCommandHandler;
import org.mockftpserver.fake.command.RntoCommandHandler;
import org.mockftpserver.fake.command.SiteCommandHandler;
import org.mockftpserver.fake.command.SizeCommandHandler;
import org.mockftpserver.fake.command.SmntCommandHandler;
import org.mockftpserver.fake.command.StatCommandHandler;
import org.mockftpserver.fake.command.StorCommandHandler;
import org.mockftpserver.fake.command.StouCommandHandler;
import org.mockftpserver.fake.command.StruCommandHandler;
import org.mockftpserver.fake.command.SystCommandHandler;
import org.mockftpserver.fake.command.TypeCommandHandler;
import org.mockftpserver.fake.command.UserCommandHandler;
import org.mockftpserver.fake.filesystem.FileSystem;

public class FakeFtpServer
extends AbstractFtpServer
implements ServerConfiguration {
    private FileSystem fileSystem;
    private String systemName;
    private String systemStatus = "Connected";
    private Map helpText = new HashMap();
    private Map userAccounts = new HashMap();

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public String getSystemName() {
        return this.systemName != null ? this.systemName : this.fileSystem.getSystemName();
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public Map getHelpText() {
        return this.helpText;
    }

    public void setHelpText(Map helpText) {
        this.helpText = helpText;
    }

    public FakeFtpServer() {
        this.setCommandHandler("ACCT", new AcctCommandHandler());
        this.setCommandHandler("ABOR", new AborCommandHandler());
        this.setCommandHandler("ALLO", new AlloCommandHandler());
        this.setCommandHandler("APPE", new AppeCommandHandler());
        this.setCommandHandler("CWD", new CwdCommandHandler());
        this.setCommandHandler("CDUP", new CdupCommandHandler());
        this.setCommandHandler("DELE", new DeleCommandHandler());
        this.setCommandHandler("EPRT", new EprtCommandHandler());
        this.setCommandHandler("EPSV", new EpsvCommandHandler());
        this.setCommandHandler("HELP", new HelpCommandHandler());
        this.setCommandHandler("LIST", new ListCommandHandler());
        this.setCommandHandler("MKD", new MkdCommandHandler());
        this.setCommandHandler("MODE", new ModeCommandHandler());
        this.setCommandHandler("NLST", new NlstCommandHandler());
        this.setCommandHandler("NOOP", new NoopCommandHandler());
        this.setCommandHandler("PASS", new PassCommandHandler());
        this.setCommandHandler("PASV", new PasvCommandHandler());
        this.setCommandHandler("PWD", new PwdCommandHandler());
        this.setCommandHandler("PORT", new PortCommandHandler());
        this.setCommandHandler("QUIT", new QuitCommandHandler());
        this.setCommandHandler("REIN", new ReinCommandHandler());
        this.setCommandHandler("REST", new RestCommandHandler());
        this.setCommandHandler("RETR", new RetrCommandHandler());
        this.setCommandHandler("RMD", new RmdCommandHandler());
        this.setCommandHandler("RNFR", new RnfrCommandHandler());
        this.setCommandHandler("RNTO", new RntoCommandHandler());
        this.setCommandHandler("SITE", new SiteCommandHandler());
        this.setCommandHandler("SIZE", new SizeCommandHandler());
        this.setCommandHandler("SMNT", new SmntCommandHandler());
        this.setCommandHandler("STAT", new StatCommandHandler());
        this.setCommandHandler("STOR", new StorCommandHandler());
        this.setCommandHandler("STOU", new StouCommandHandler());
        this.setCommandHandler("STRU", new StruCommandHandler());
        this.setCommandHandler("SYST", new SystCommandHandler());
        this.setCommandHandler("TYPE", new TypeCommandHandler());
        this.setCommandHandler("USER", new UserCommandHandler());
        this.setCommandHandler("XPWD", new PwdCommandHandler());
        this.setCommandHandler("CONNECT", new ConnectCommandHandler());
        this.setCommandHandler("UNSUPPORTED", new UnsupportedCommandHandler());
    }

    @Override
    protected void initializeCommandHandler(CommandHandler commandHandler) {
        if (commandHandler instanceof ServerConfigurationAware) {
            ServerConfigurationAware sca = (ServerConfigurationAware)((Object)commandHandler);
            sca.setServerConfiguration(this);
        }
        ReplyTextBundleUtil.setReplyTextBundleIfAppropriate(commandHandler, this.getReplyTextBundle());
    }

    @Override
    public UserAccount getUserAccount(String username) {
        return (UserAccount)this.userAccounts.get(username);
    }

    @Override
    public String getHelpText(String name) {
        String key = name == null ? "" : name;
        return (String)this.helpText.get(key);
    }

    public void addUserAccount(UserAccount userAccount) {
        this.userAccounts.put(userAccount.getUsername(), userAccount);
    }

    public void setUserAccounts(List userAccountList) {
        for (int i = 0; i < userAccountList.size(); ++i) {
            UserAccount userAccount = (UserAccount)userAccountList.get(i);
            this.userAccounts.put(userAccount.getUsername(), userAccount);
        }
    }

    @Override
    public String getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(String systemStatus) {
        this.systemStatus = systemStatus;
    }
}

