/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;

public class UserCommandHandler
extends AbstractFakeCommandHandler {
    @Override
    protected void handle(Command command, Session session) {
        String username = command.getRequiredParameter(0);
        UserAccount userAccount = this.getServerConfiguration().getUserAccount(username);
        if (userAccount != null) {
            if (!this.validateUserAccount(username, session)) {
                return;
            }
            if (!userAccount.isPasswordRequiredForLogin()) {
                this.login(userAccount, session, 230, "user.loggedIn");
                return;
            }
        }
        session.setAttribute("username", username);
        this.sendReply(session, 331, "user.needPassword");
    }
}

