/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import java.util.StringTokenizer;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.stub.command.AbstractStubCommandHandler;

public class AlloCommandHandler
extends AbstractStubCommandHandler
implements CommandHandler {
    public static final String NUMBER_OF_BYTES_KEY = "numberOfBytes";
    public static final String RECORD_SIZE_KEY = "recordSize";
    private static final String RECORD_SIZE_DELIMITER = " R ";

    public AlloCommandHandler() {
        this.setReplyCode(200);
    }

    public void handleCommand(Command command, Session session, InvocationRecord invocationRecord) {
        String parametersString = command.getRequiredParameter(0);
        if (parametersString.indexOf(RECORD_SIZE_DELIMITER) == -1) {
            invocationRecord.set(NUMBER_OF_BYTES_KEY, Integer.valueOf(parametersString));
        } else {
            StringTokenizer tokenizer = new StringTokenizer(parametersString, RECORD_SIZE_DELIMITER);
            invocationRecord.set(NUMBER_OF_BYTES_KEY, Integer.valueOf(tokenizer.nextToken()));
            Assert.isTrue(tokenizer.hasMoreTokens(), "Missing record size: [" + parametersString + "]");
            invocationRecord.set(RECORD_SIZE_KEY, Integer.valueOf(tokenizer.nextToken()));
        }
        this.sendReply(session);
    }
}

