/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;
import org.mockftpserver.fake.filesystem.DirectoryEntry;

public class MkdCommandHandler
extends AbstractFakeCommandHandler {
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        String path = this.getRealPath(session, command.getRequiredParameter(0));
        String parent = this.getFileSystem().getParent(path);
        this.replyCodeForFileSystemException = 550;
        this.verifyFileSystemCondition(this.getFileSystem().exists(parent), parent, "filesystem.doesNotExist");
        this.verifyFileSystemCondition(!this.getFileSystem().exists(path), path, "filesystem.alreadyExists");
        this.verifyWritePermission(session, parent);
        this.verifyExecutePermission(session, parent);
        DirectoryEntry dirEntry = new DirectoryEntry(path);
        this.getFileSystem().add(dirEntry);
        dirEntry.setPermissions(this.getUserAccount(session).getDefaultPermissionsForNewDirectory());
        this.sendReply(session, 257, "mkd", this.list(path));
    }
}

