/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake;

import java.util.List;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.Permissions;

public class UserAccount {
    public static final String DEFAULT_USER = "system";
    public static final String DEFAULT_GROUP = "users";
    public static final Permissions DEFAULT_PERMISSIONS_FOR_NEW_FILE = new Permissions("rw-rw-rw-");
    public static final Permissions DEFAULT_PERMISSIONS_FOR_NEW_DIRECTORY = Permissions.ALL;
    private String username;
    private String password;
    private String homeDirectory;
    private List groups;
    private boolean passwordRequiredForLogin = true;
    private boolean passwordCheckedDuringValidation = true;
    private boolean accountRequiredForLogin = false;
    private Permissions defaultPermissionsForNewFile = DEFAULT_PERMISSIONS_FOR_NEW_FILE;
    private Permissions defaultPermissionsForNewDirectory = DEFAULT_PERMISSIONS_FOR_NEW_DIRECTORY;

    public UserAccount() {
    }

    public UserAccount(String username, String password, String homeDirectory) {
        this.setUsername(username);
        this.setPassword(password);
        this.setHomeDirectory(homeDirectory);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public List getGroups() {
        return this.groups;
    }

    public void setGroups(List groups) {
        this.groups = groups;
    }

    public boolean isPasswordRequiredForLogin() {
        return this.passwordRequiredForLogin;
    }

    public void setPasswordRequiredForLogin(boolean passwordRequiredForLogin) {
        this.passwordRequiredForLogin = passwordRequiredForLogin;
    }

    public boolean isPasswordCheckedDuringValidation() {
        return this.passwordCheckedDuringValidation;
    }

    public void setPasswordCheckedDuringValidation(boolean passwordCheckedDuringValidation) {
        this.passwordCheckedDuringValidation = passwordCheckedDuringValidation;
    }

    public boolean isAccountRequiredForLogin() {
        return this.accountRequiredForLogin;
    }

    public void setAccountRequiredForLogin(boolean accountRequiredForLogin) {
        this.accountRequiredForLogin = accountRequiredForLogin;
    }

    public Permissions getDefaultPermissionsForNewFile() {
        return this.defaultPermissionsForNewFile;
    }

    public void setDefaultPermissionsForNewFile(Permissions defaultPermissionsForNewFile) {
        this.defaultPermissionsForNewFile = defaultPermissionsForNewFile;
    }

    public Permissions getDefaultPermissionsForNewDirectory() {
        return this.defaultPermissionsForNewDirectory;
    }

    public void setDefaultPermissionsForNewDirectory(Permissions defaultPermissionsForNewDirectory) {
        this.defaultPermissionsForNewDirectory = defaultPermissionsForNewDirectory;
    }

    public String getPrimaryGroup() {
        return this.groups == null || this.groups.isEmpty() ? DEFAULT_GROUP : (String)this.groups.get(0);
    }

    public boolean isValidPassword(String password) {
        Assert.notNullOrEmpty(this.username, "username");
        return !this.passwordCheckedDuringValidation || this.comparePassword(password);
    }

    public boolean isValid() {
        return this.homeDirectory != null && this.homeDirectory.length() > 0;
    }

    public String toString() {
        return "UserAccount[username=" + this.username + "; password=" + this.password + "; homeDirectory=" + this.homeDirectory + "; passwordRequiredForLogin=" + this.passwordRequiredForLogin + "]";
    }

    public boolean canRead(FileSystemEntry entry) {
        Permissions permissions = entry.getPermissions();
        if (permissions == null) {
            return true;
        }
        if (this.equalOrBothNull(this.username, entry.getOwner())) {
            return permissions.canUserRead();
        }
        if (this.groups != null && this.groups.contains(entry.getGroup())) {
            return permissions.canGroupRead();
        }
        return permissions.canWorldRead();
    }

    public boolean canWrite(FileSystemEntry entry) {
        Permissions permissions = entry.getPermissions();
        if (permissions == null) {
            return true;
        }
        if (this.equalOrBothNull(this.username, entry.getOwner())) {
            return permissions.canUserWrite();
        }
        if (this.groups != null && this.groups.contains(entry.getGroup())) {
            return permissions.canGroupWrite();
        }
        return permissions.canWorldWrite();
    }

    public boolean canExecute(FileSystemEntry entry) {
        Permissions permissions = entry.getPermissions();
        if (permissions == null) {
            return true;
        }
        if (this.equalOrBothNull(this.username, entry.getOwner())) {
            return permissions.canUserExecute();
        }
        if (this.groups != null && this.groups.contains(entry.getGroup())) {
            return permissions.canGroupExecute();
        }
        return permissions.canWorldExecute();
    }

    protected boolean comparePassword(String password) {
        return password != null && password.equals(this.password);
    }

    protected boolean equalOrBothNull(String string1, String string2) {
        return string1 == null && string2 == null || string1 != null && string1.equals(string2);
    }
}

