/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.testing.integration.proxy;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringStartsWith;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockserver.character.Character;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.Times;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.StringBody;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.socket.tls.KeyStoreFactory;
import org.mockserver.streams.IOStreamUtils;
import org.mockserver.test.Assert;
import org.mockserver.verify.VerificationTimes;

public abstract class AbstractProxyIntegrationTest {
    protected static String servletContext = "";
    private static EventLoopGroup clientEventLoopGroup;

    @BeforeClass
    public static void createClientAndEventLoopGroup() {
        clientEventLoopGroup = new NioEventLoopGroup(3, (ThreadFactory)new Scheduler.SchedulerThreadFactory(AbstractProxyIntegrationTest.class.getSimpleName() + "-eventLoop"));
    }

    @AfterClass
    public static void stopEventLoopGroup() {
        clientEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).syncUninterruptibly();
    }

    protected HttpClient createHttpClient() {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(new KeyStoreFactory(new MockServerLogger()).sslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(System.getProperty("http.proxyHost", "127.0.0.1"), Integer.parseInt(System.getProperty("http.proxyPort", String.valueOf(this.getProxyPort())))))).build();
    }

    public abstract int getProxyPort();

    public abstract int getSecureProxyPort();

    public abstract MockServerClient getMockServerClient();

    public abstract int getServerPort();

    protected String calculatePath(String path) {
        return (!path.startsWith("/") ? "/" : "") + path;
    }

    protected String addContextToPath(String path) {
        String cleanedPath = path;
        if (StringUtils.isNotBlank((CharSequence)servletContext)) {
            cleanedPath = (!servletContext.startsWith("/") ? "/" : "") + servletContext + (!servletContext.endsWith("/") ? "/" : "") + (cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    @Before
    public void resetServer() {
        this.getMockServerClient().reset();
    }

    @Test
    public void shouldForwardRequestsUsingSocketDirectly() throws Exception {
        try (Socket socket = new Socket("127.0.0.1", this.getProxyPort());){
            OutputStream output = socket.getOutputStream();
            output.write(("GET " + this.addContextToPath("test_headers_only") + " HTTP/1.1\r" + Character.NEW_LINE + "Host: 127.0.0.1:" + this.getServerPort() + "\r" + Character.NEW_LINE + "x-test: test_headers_only\r" + Character.NEW_LINE + "Content-Length: 0\r" + Character.NEW_LINE + "Connection: keep-alive\r" + Character.NEW_LINE + "\r" + Character.NEW_LINE).getBytes(StandardCharsets.UTF_8));
            output.flush();
            Assert.assertContains((String)IOStreamUtils.readInputStreamToString((Socket)socket), (String)"x-test: test_headers_only");
            this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_only"), VerificationTimes.exactly((int)1));
            output.write(("GET " + this.addContextToPath("test_headers_and_body") + " HTTP/1.1\r" + Character.NEW_LINE + "Host: 127.0.0.1:" + this.getServerPort() + "\r" + Character.NEW_LINE + "Content-Length: " + "an_example_body".getBytes(StandardCharsets.UTF_8).length + "\r" + Character.NEW_LINE + "x-test: test_headers_and_body\r" + Character.NEW_LINE + "\r" + Character.NEW_LINE + "an_example_body").getBytes(StandardCharsets.UTF_8));
            output.flush();
            String response = IOStreamUtils.readInputStreamToString((Socket)socket);
            Assert.assertContains((String)response, (String)"x-test: test_headers_and_body");
            Assert.assertContains((String)response, (String)"an_example_body");
        }
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body").withBody("an_example_body"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldForwardRequestsUsingHttpClient() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build());
        request.setEntity((HttpEntity)new StringEntity("an_example_body"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        org.junit.Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        org.junit.Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("POST").withPath("/test_headers_and_body").withBody("an_example_body"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldForwardRequestsWithComplexCookies() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        BasicHeader setCookieOneHeader = new BasicHeader("Set-Cookie", "personalization_59996b985e24ce008d3df3bd07e27c1b=\"\"; Expires=Thu, 01-Jan-1970 00:00:10 GMT; Path=/");
        BasicHeader setCookieTwoHeader = new BasicHeader("Set-Cookie", "anonymous_59996b985e24ce008d3df3bd07e27c1b=acgzEaAKOVR=mAY9yJhP7IrC9Am; Version=1; Comment=\"Anonymous cookie for site\"; Max-Age=15552000; Expires=Sat, 19-Mar-2016 18:43:26 GMT; Path=/");
        BasicHeader cookieOneHeader = new BasicHeader("Cookie", "personalization_59996b985e24ce008d3df3bd07e27c1b=\"\"");
        BasicHeader cookieTwoHeader = new BasicHeader("Cookie", "anonymous_59996b985e24ce008d3df3bd07e27c1b=\"acgzEaAKOVR=mAY9yJhP7IrC9Am\"");
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build());
        request.addHeader((Header)setCookieOneHeader);
        request.addHeader((Header)setCookieTwoHeader);
        request.addHeader((Header)cookieOneHeader);
        request.addHeader((Header)cookieTwoHeader);
        request.setEntity((HttpEntity)new StringEntity("an_example_body"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        org.junit.Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        MatcherAssert.assertThat((Object)response.getHeaders("Set-Cookie").length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)response.getHeaders("Set-Cookie")[0].getValue(), (Matcher)Matchers.is((Object)setCookieOneHeader.getValue()));
        MatcherAssert.assertThat((Object)response.getHeaders("Set-Cookie")[1].getValue(), (Matcher)Matchers.is((Object)setCookieTwoHeader.getValue()));
        org.junit.Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("POST").withPath("/test_headers_and_body").withHeader(setCookieOneHeader.getName(), new String[]{setCookieOneHeader.getValue()}).withHeader(setCookieTwoHeader.getName(), new String[]{setCookieTwoHeader.getValue()}).withCookie("personalization_59996b985e24ce008d3df3bd07e27c1b", "").withCookie("anonymous_59996b985e24ce008d3df3bd07e27c1b", "acgzEaAKOVR=mAY9yJhP7IrC9Am").withBody("an_example_body"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldForwardRequestsWithCharset() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        String body = "{" + Character.NEW_LINE + "\"field\" : \"" + Base64.getEncoder().encodeToString(RandomUtils.nextBytes((int)50)) + "\"" + Character.NEW_LINE + "}";
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build());
        request.setEntity((HttpEntity)new StringEntity(body));
        request.setHeader("Content-Type", "application/encrypted;charset=utf-8");
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        org.junit.Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        org.junit.Assert.assertEquals((Object)body, (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("POST").withPath("/test_headers_and_body").withBody(body), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldForwardRequestsToUnknownPath() throws Exception {
        try (Socket socket = new Socket("127.0.0.1", this.getProxyPort());){
            OutputStream output = socket.getOutputStream();
            output.write(("GET " + this.addContextToPath("not_found") + " HTTP/1.1\r" + Character.NEW_LINE + "Host: 127.0.0.1:" + this.getServerPort() + "\r" + Character.NEW_LINE + "Connection: close\r" + Character.NEW_LINE + "\r" + Character.NEW_LINE).getBytes(StandardCharsets.UTF_8));
            output.flush();
            Assert.assertContains((String)IOStreamUtils.readInputStreamToString((Socket)socket), (String)"HTTP/1.1 404");
        }
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/not_found"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldReturnResponseByMatchingPathExactTimes() throws URISyntaxException, IOException {
        this.getMockServerClient().when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1)).respond(org.mockserver.model.HttpResponse.response().withBody("some_body"));
        HttpClient httpClient = this.createHttpClient();
        HttpGet request = new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("some_path")).build());
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        MatcherAssert.assertThat((Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"some_body"));
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)HttpStatusCode.OK_200.code()));
        httpClient = this.createHttpClient();
        request = new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("some_path")).build());
        response = httpClient.execute((HttpUriRequest)request);
        MatcherAssert.assertThat((Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void shouldReturnResponseByMatchingStringBody() throws IOException, URISyntaxException {
        this.getMockServerClient().when((RequestDefinition)HttpRequest.request().withBody((Body)StringBody.exact((String)"some_random_body")), Times.exactly((int)2)).respond(org.mockserver.model.HttpResponse.response().withBody("some_string_body_response"));
        HttpClient httpClient = this.createHttpClient();
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("some_path")).build());
        request.setEntity((HttpEntity)new StringEntity("some_random_body"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        MatcherAssert.assertThat((Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"some_string_body_response"));
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)HttpStatusCode.OK_200.code()));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonSchema() throws URISyntaxException, IOException {
        this.getMockServerClient().when((RequestDefinition)HttpRequest.request().withBody((Body)JsonSchemaBody.jsonSchema((String)("{" + Character.NEW_LINE + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + Character.NEW_LINE + "    \"title\": \"Product\"," + Character.NEW_LINE + "    \"description\": \"A product from Acme's catalog\"," + Character.NEW_LINE + "    \"type\": \"object\"," + Character.NEW_LINE + "    \"properties\": {" + Character.NEW_LINE + "        \"id\": {" + Character.NEW_LINE + "            \"description\": \"The unique identifier for a product\"," + Character.NEW_LINE + "            \"type\": \"integer\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"name\": {" + Character.NEW_LINE + "            \"description\": \"Name of the product\"," + Character.NEW_LINE + "            \"type\": \"string\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"price\": {" + Character.NEW_LINE + "            \"type\": \"number\"," + Character.NEW_LINE + "            \"minimum\": 0," + Character.NEW_LINE + "            \"exclusiveMinimum\": true" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"tags\": {" + Character.NEW_LINE + "            \"type\": \"array\"," + Character.NEW_LINE + "            \"items\": {" + Character.NEW_LINE + "                \"type\": \"string\"" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            \"minItems\": 1," + Character.NEW_LINE + "            \"uniqueItems\": true" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"required\": [\"id\", \"name\", \"price\"]" + Character.NEW_LINE + "}"))), Times.exactly((int)2)).respond(org.mockserver.model.HttpResponse.response().withBody("some_body"));
        HttpClient httpClient = this.createHttpClient();
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("some_path")).build());
        request.setEntity((HttpEntity)new StringEntity("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        MatcherAssert.assertThat((Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"some_body"));
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)HttpStatusCode.OK_200.code()));
    }

    @Test
    public void shouldVerifyRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_only")).build()));
        this.getMockServerClient().verify(new RequestDefinition[]{HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body")});
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), VerificationTimes.exactly((int)1));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.atLeast((int)1));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.exactly((int)2));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/other_path"), VerificationTimes.exactly((int)0));
    }

    @Test
    public void shouldVerifyRequestsSequence() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_only")).build()));
        this.getMockServerClient().verify(new RequestDefinition[]{HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), HttpRequest.request().withMethod("GET").withPath("/test_headers_only")});
    }

    @Test
    public void shouldVerifyRequestsWithHopByHopHeaders() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        HttpGet httpGet = new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_only")).build());
        httpGet.addHeader("Proxy-Authorization", "some-random_value");
        httpGet.addHeader("keep-alive", "false");
        httpClient.execute((HttpUriRequest)httpGet);
        this.getMockServerClient().verify(new RequestDefinition[]{HttpRequest.request().withMethod("GET").withPath("/test_headers_only").withHeader("Proxy-Authorization", new String[]{"some-random_value"}).withHeader("keep-alive", new String[]{"false"})});
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_only").withHeader("Proxy-Authorization", new String[0]).withHeader("keep-alive", new String[0]), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyZeroRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        try {
            this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_and_body"), VerificationTimes.exactly((int)0));
            org.junit.Assert.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 0 times, expected:<{" + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"" + Character.NEW_LINE + "}> but was:<{" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"," + Character.NEW_LINE)));
        }
    }

    @Test
    public void shouldVerifyNoRequestsExactly() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        try {
            this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/other_path"), VerificationTimes.exactly((int)1));
            org.junit.Assert.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly once, expected:<{" + Character.NEW_LINE + "  \"path\" : \"/other_path\"" + Character.NEW_LINE + "}> but was:<{" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"," + Character.NEW_LINE)));
        }
    }

    @Test
    public void shouldVerifyNoRequestsTimesNotSpecified() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        try {
            this.getMockServerClient().verify(new RequestDefinition[]{HttpRequest.request().withPath("/other_path")});
            org.junit.Assert.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + Character.NEW_LINE + "  \"path\" : \"/other_path\"" + Character.NEW_LINE + "} ]> but was:<{" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"," + Character.NEW_LINE)));
        }
    }

    @Test
    public void shouldVerifyNotEnoughRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        try {
            this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_and_body"), VerificationTimes.atLeast((int)3));
            org.junit.Assert.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least 3 times, expected:<{" + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"" + Character.NEW_LINE + "}> but was:<[ {" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"," + Character.NEW_LINE)));
        }
    }

    @Test
    public void shouldVerifyRequestsSequenceNotFound() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_only")).build()));
        try {
            this.getMockServerClient().verify(new RequestDefinition[]{HttpRequest.request().withMethod("GET").withPath("/test_headers_only"), HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body")});
            org.junit.Assert.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_only\"" + Character.NEW_LINE + "}, {" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"" + Character.NEW_LINE + "} ]> but was:<[ {" + Character.NEW_LINE + "  \"method\" : \"GET\"," + Character.NEW_LINE + "  \"path\" : \"/test_headers_and_body\"," + Character.NEW_LINE + "  \"headers\" : {")));
        }
    }

    @Test
    public void shouldClearRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_only")).build()));
        this.getMockServerClient().clear((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), VerificationTimes.exactly((int)0));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldResetRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("127.0.0.1").setPort(this.getServerPort()).setPath(this.addContextToPath("test_headers_only")).build()));
        this.getMockServerClient().reset();
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), VerificationTimes.exactly((int)0));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.atLeast((int)0));
        this.getMockServerClient().verify((RequestDefinition)HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.exactly((int)0));
    }

    @Test
    public void shouldReturnErrorForInvalidRequestToClear() throws Exception {
        org.mockserver.model.HttpResponse httpResponse = (org.mockserver.model.HttpResponse)new NettyHttpClient(new MockServerLogger(), clientEventLoopGroup, null, false).sendRequest(HttpRequest.request().withMethod("PUT").withHeader(HttpHeaderNames.HOST.toString(), new String[]{"127.0.0.1:" + this.getProxyPort()}).withPath(this.addContextToPath("mockserver/clear")).withBody("{" + Character.NEW_LINE + "    \"path\" : 500," + Character.NEW_LINE + "    \"method\" : true," + Character.NEW_LINE + "    \"keepAlive\" : \"false\"" + Character.NEW_LINE + "  }")).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)httpResponse.getBodyAsString(), (Matcher)Matchers.is((Object)("incorrect request matcher json format for:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  {" + Character.NEW_LINE + "      \"path\" : 500," + Character.NEW_LINE + "      \"method\" : true," + Character.NEW_LINE + "      \"keepAlive\" : \"false\"" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "" + Character.NEW_LINE + " schema validation errors:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  10 errors:" + Character.NEW_LINE + "   - field: \"/keepAlive\" for schema: \"httpRequest/properties/keepAlive\" has error: \"instance type (string) does not match any allowed primitive type (allowed: [\"boolean\"])\"" + Character.NEW_LINE + "   - field: \"/method\" for schema: \"stringOrJsonSchema\" has error: \"instance failed to match exactly one schema (matched 0 out of 2)\"" + Character.NEW_LINE + "   - field: \"/method\" for schema: \"stringOrJsonSchema/oneOf/0\" has error: \"instance type (boolean) does not match any allowed primitive type (allowed: [\"string\"])\"" + Character.NEW_LINE + "   - field: \"/method\" for schema: \"stringOrJsonSchema/oneOf/1\" has error: \"instance type (boolean) does not match any allowed primitive type (allowed: [\"object\"])\"" + Character.NEW_LINE + "   - field: \"/path\" for schema: \"stringOrJsonSchema\" has error: \"instance failed to match exactly one schema (matched 0 out of 2)\"" + Character.NEW_LINE + "   - field: \"/path\" for schema: \"stringOrJsonSchema/oneOf/0\" has error: \"instance type (integer) does not match any allowed primitive type (allowed: [\"string\"])\"" + Character.NEW_LINE + "   - field: \"/path\" for schema: \"stringOrJsonSchema/oneOf/1\" has error: \"instance type (integer) does not match any allowed primitive type (allowed: [\"object\"])\"" + Character.NEW_LINE + "   - oneOf of the following must be specified [\"httpRequest\", \"openAPIDefinition\"] but found 0 without errors" + Character.NEW_LINE + "   - schema: \"openAPIDefinition\" has error: \"object has missing required properties ([\"specUrlOrPayload\"])\"" + Character.NEW_LINE + "   - schema: \"openAPIDefinition\" has error: \"object instance has properties which are not allowed by the schema: [\"keepAlive\",\"method\",\"path\"]\"" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  " + "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification")));
    }

    @Test
    public void shouldReturnErrorForInvalidRequestToVerify() throws Exception {
        org.mockserver.model.HttpResponse httpResponse = (org.mockserver.model.HttpResponse)new NettyHttpClient(new MockServerLogger(), clientEventLoopGroup, null, false).sendRequest(HttpRequest.request().withMethod("PUT").withHeader(HttpHeaderNames.HOST.toString(), new String[]{"127.0.0.1:" + this.getProxyPort()}).withPath(this.addContextToPath("mockserver/verify")).withBody("{" + Character.NEW_LINE + "    \"httpRequest\": {" + Character.NEW_LINE + "        \"path\": \"/simple\"" + Character.NEW_LINE + "    }, " + Character.NEW_LINE + "    \"times\": 1" + Character.NEW_LINE + "}")).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)httpResponse.getBodyAsString(), (Matcher)Matchers.is((Object)("incorrect verification json format for:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  {" + Character.NEW_LINE + "      \"httpRequest\": {" + Character.NEW_LINE + "          \"path\": \"/simple\"" + Character.NEW_LINE + "      }, " + Character.NEW_LINE + "      \"times\": 1" + Character.NEW_LINE + "  }" + Character.NEW_LINE + "" + Character.NEW_LINE + " schema validation errors:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  1 error:" + Character.NEW_LINE + "   - field: \"/times\" for schema: \"verificationTimes\" has error: \"instance type (integer) does not match any allowed primitive type (allowed: [\"object\"])\"" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  " + "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification")));
    }

    @Test
    public void shouldReturnErrorForInvalidRequestToVerifySequence() throws Exception {
        org.mockserver.model.HttpResponse httpResponse = (org.mockserver.model.HttpResponse)new NettyHttpClient(new MockServerLogger(), clientEventLoopGroup, null, false).sendRequest(HttpRequest.request().withMethod("PUT").withHeader(HttpHeaderNames.HOST.toString(), new String[]{"127.0.0.1:" + this.getProxyPort()}).withPath(this.addContextToPath("mockserver/verifySequence")).withBody("{" + Character.NEW_LINE + "    \"httpRequest\": {" + Character.NEW_LINE + "        \"path\": false" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"httpRequest\": {" + Character.NEW_LINE + "        \"path\": 10" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "}")).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)httpResponse.getBodyAsString(), (Matcher)Matchers.is((Object)("incorrect verification sequence json format for:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  {" + Character.NEW_LINE + "      \"httpRequest\": {" + Character.NEW_LINE + "          \"path\": false" + Character.NEW_LINE + "      }," + Character.NEW_LINE + "      \"httpRequest\": {" + Character.NEW_LINE + "          \"path\": 10" + Character.NEW_LINE + "      }" + Character.NEW_LINE + "  }" + Character.NEW_LINE + "" + Character.NEW_LINE + " schema validation errors:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  1 error:" + Character.NEW_LINE + "   - object instance has properties which are not allowed by the schema: [\"httpRequest\"]" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  " + "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification")));
    }
}

