/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.testing.integration.mock;

import java.util.concurrent.TimeUnit;
import javax.script.ScriptEngineManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.character.Character;
import org.mockserver.model.Header;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.RequestDefinition;
import org.mockserver.testing.integration.callback.StaticTestExpectationResponseCallback;
import org.mockserver.testing.integration.mock.AbstractExtendedMockingIntegrationTest;

public abstract class AbstractExtendedSameJVMMockingIntegrationTest
extends AbstractExtendedMockingIntegrationTest {
    @Test
    public void shouldCallbackToSpecifiedClassWithDynamicResponse() {
        StaticTestExpectationResponseCallback.httpRequests.clear();
        StaticTestExpectationResponseCallback.httpResponse = HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response");
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("callback"))).respond(HttpClassCallback.callback().withCallbackClass(StaticTestExpectationResponseCallback.class));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"X-Test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), headersToIgnore));
        Assert.assertEquals((Object)StaticTestExpectationResponseCallback.httpRequests.get(0).getBody().getValue(), (Object)"an_example_body_http");
        Assert.assertEquals((Object)StaticTestExpectationResponseCallback.httpRequests.get(0).getPath().getValue(), (Object)this.calculatePath("callback"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"X-Test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), headersToIgnore));
        Assert.assertEquals((Object)StaticTestExpectationResponseCallback.httpRequests.get(1).getBody().getValue(), (Object)"an_example_body_https");
        Assert.assertEquals((Object)StaticTestExpectationResponseCallback.httpRequests.get(1).getPath().getValue(), (Object)this.calculatePath("callback"));
    }

    @Test
    public void shouldReturnResponseFromJavaScriptTemplate() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path"))).respond(HttpTemplate.template((HttpTemplate.TemplateType)HttpTemplate.TemplateType.JAVASCRIPT, (String)("return {" + Character.NEW_LINE + "     'statusCode': 200," + Character.NEW_LINE + "     'cookies': [ { name: 'name', value: request.cookies['name'] } ],     'body': JSON.stringify(" + Character.NEW_LINE + "               {" + Character.NEW_LINE + "                    method: request.method,                    path: request.path,                    body: request.body               }" + Character.NEW_LINE + "          )" + Character.NEW_LINE + "};" + Character.NEW_LINE)));
        if (new ScriptEngineManager().getEngineByName("nashorn") != null) {
            Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withCookie("name", "value").withHeader("set-cookie", new String[]{"name=value"}).withBody("{\"method\":\"GET\",\"path\":\"/some_path\",\"body\":\"some_request_body\"}"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withCookie("name", "value").withBody("some_request_body"), headersToIgnore));
            Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withCookie("name", "value").withHeader("set-cookie", new String[]{"name=value"}).withBody("{\"method\":\"GET\",\"path\":\"/some_path\",\"body\":\"some_request_body\"}"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withCookie("name", "value").withBody("some_request_body"), headersToIgnore));
        } else {
            Assert.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withCookie("name", "value").withBody("some_request_body"), headersToIgnore));
            Assert.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withCookie("name", "value").withBody("some_request_body"), headersToIgnore));
        }
    }

    @Test
    public void shouldForwardTemplateInJavaScript() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward((HttpTemplate)HttpTemplate.template((HttpTemplate.TemplateType)HttpTemplate.TemplateType.JAVASCRIPT, (String)("return {" + Character.NEW_LINE + "    'path' : \"/somePath\"," + Character.NEW_LINE + "    'headers' : [ {" + Character.NEW_LINE + "        'name' : \"Host\"," + Character.NEW_LINE + "        'values' : [ \"127.0.0.1:" + insecureEchoServer.getPort() + "\" ]" + Character.NEW_LINE + "    }, {" + Character.NEW_LINE + "        'name' : \"x-test\"," + Character.NEW_LINE + "        'values' : [ request.headers['x-test'][0] ]" + Character.NEW_LINE + "    } ]," + Character.NEW_LINE + "    'body': \"template_\" + request.body" + Character.NEW_LINE + "};")).withDelay(TimeUnit.MILLISECONDS, 10L));
        if (new ScriptEngineManager().getEngineByName("nashorn") != null) {
            Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("template_an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), headersToIgnore));
            Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("template_an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), headersToIgnore));
        } else {
            Assert.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withCookie("name", "value").withBody("some_request_body"), headersToIgnore));
            Assert.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withCookie("name", "value").withBody("some_request_body"), headersToIgnore));
        }
    }
}

