/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.JsonPathBodyDTO;
import org.mockserver.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.RegexBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XPathBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.mockserver.serialization.model.XmlSchemaBodyDTO;
import org.slf4j.event.Level;

public class BodyDTODeserializer
extends StdDeserializer<BodyDTO> {
    private static final Map<String, Body.Type> fieldNameToType = new HashMap<String, Body.Type>();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static ObjectMapper objectMapper;
    private static ObjectMapper jsonBodyObjectMapper;
    private static final MockServerLogger MOCK_SERVER_LOGGER;

    public BodyDTODeserializer() {
        super(BodyDTO.class);
    }

    public BodyDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        byte[] rawBytes = null;
        Enum type = null;
        boolean not = false;
        MediaType contentType = null;
        Charset charset = null;
        boolean subString = false;
        MatchType matchType = JsonBody.DEFAULT_MATCH_TYPE;
        Parameters parameters = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("type")) {
                    try {
                        type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                    }
                    catch (IllegalArgumentException iae) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring invalid value for \"type\" field of \"" + entry.getValue() + "\""));
                    }
                }
                if (this.containsIgnoreCase(key, "string", "regex", "json", "jsonSchema", "jsonPath", "xml", "xmlSchema", "xpath", "base64Bytes") && type != Body.Type.PARAMETERS) {
                    String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                    if (fieldNameToType.containsKey(fieldName)) {
                        type = fieldNameToType.get(fieldName);
                    }
                    if (Map.class.isAssignableFrom(entry.getValue().getClass())) {
                        if (objectMapper == null) {
                            objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
                        }
                        valueJsonValue = objectMapper.writeValueAsString(entry.getValue());
                    } else {
                        valueJsonValue = String.valueOf(entry.getValue());
                    }
                }
                if (this.containsIgnoreCase(key, "rawBytes", "base64Bytes") && entry.getValue() instanceof String) {
                    try {
                        rawBytes = BASE64_DECODER.decode((String)entry.getValue());
                    }
                    catch (Throwable throwable) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("invalid base64 encoded rawBytes with value \"" + entry.getValue() + "\""));
                    }
                }
                if (key.equalsIgnoreCase("not")) {
                    not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                }
                if (key.equalsIgnoreCase("matchType")) {
                    try {
                        matchType = MatchType.valueOf(String.valueOf(entry.getValue()));
                    }
                    catch (IllegalArgumentException iae) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring incorrect JsonBodyMatchType with value \"" + entry.getValue() + "\""));
                    }
                }
                if (key.equalsIgnoreCase("subString")) {
                    try {
                        subString = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                    }
                    catch (IllegalArgumentException uce) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring unsupported boolean with value \"" + entry.getValue() + "\""));
                    }
                }
                if (key.equalsIgnoreCase("contentType")) {
                    try {
                        String mediaTypeHeader = String.valueOf(entry.getValue());
                        if (StringUtils.isNotBlank((CharSequence)mediaTypeHeader)) {
                            contentType = MediaType.parse(mediaTypeHeader);
                        }
                    }
                    catch (IllegalArgumentException uce) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring unsupported MediaType with value \"" + entry.getValue() + "\""));
                    }
                }
                if (key.equalsIgnoreCase("charset")) {
                    try {
                        charset = Charset.forName(String.valueOf(entry.getValue()));
                    }
                    catch (UnsupportedCharsetException uce) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring unsupported Charset with value \"" + entry.getValue() + "\""));
                    }
                    catch (IllegalCharsetNameException icne) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring invalid Charset with value \"" + entry.getValue() + "\""));
                    }
                }
                if (!key.equalsIgnoreCase("parameters")) continue;
                if (objectMapper == null) {
                    objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
                }
                parameters = (Parameters)objectMapper.readValue(objectMapper.writeValueAsString(entry.getValue()), Parameters.class);
            }
            if (type != null) {
                switch (1.$SwitchMap$org$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null) {
                            return new BinaryBodyDTO(new BinaryBody(rawBytes, contentType), (Boolean)not);
                        }
                        return new BinaryBodyDTO(new BinaryBody(rawBytes), (Boolean)not);
                    }
                    case 2: {
                        if (contentType != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, contentType, matchType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_CONTENT_TYPE.withCharset(charset), matchType), (Boolean)not);
                        }
                        return new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_CONTENT_TYPE, matchType), (Boolean)not);
                    }
                    case 3: {
                        return new JsonSchemaBodyDTO(new JsonSchemaBody(valueJsonValue), (Boolean)not);
                    }
                    case 4: {
                        return new JsonPathBodyDTO(new JsonPathBody(valueJsonValue), (Boolean)not);
                    }
                    case 5: {
                        return new ParameterBodyDTO(new ParameterBody(parameters), (Boolean)not);
                    }
                    case 6: {
                        return new RegexBodyDTO(new RegexBody(valueJsonValue), (Boolean)not);
                    }
                    case 7: {
                        if (contentType != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, StringBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), (Boolean)not);
                        }
                        return new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, null), (Boolean)not);
                    }
                    case 8: {
                        if (contentType != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), (Boolean)not);
                        }
                        return new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_CONTENT_TYPE), (Boolean)not);
                    }
                    case 9: {
                        return new XmlSchemaBodyDTO(new XmlSchemaBody(valueJsonValue), (Boolean)not);
                    }
                    case 10: {
                        return new XPathBodyDTO(new XPathBody(valueJsonValue), (Boolean)not);
                    }
                }
            } else if (body.size() > 0) {
                if (jsonBodyObjectMapper == null) {
                    jsonBodyObjectMapper = new ObjectMapper();
                }
                return new JsonBodyDTO(new JsonBody(jsonBodyObjectMapper.writeValueAsString((Object)body), JsonBody.DEFAULT_MATCH_TYPE), (Boolean)false);
            }
        } else {
            if (currentToken == JsonToken.START_ARRAY) {
                if (jsonBodyObjectMapper == null) {
                    jsonBodyObjectMapper = new ObjectMapper();
                }
                return new JsonBodyDTO(new JsonBody(jsonBodyObjectMapper.writeValueAsString(ctxt.readValue(jsonParser, List.class)), JsonBody.DEFAULT_MATCH_TYPE), (Boolean)false);
            }
            if (currentToken == JsonToken.VALUE_STRING) {
                return new StringBodyDTO(new StringBody(jsonParser.getText()));
            }
        }
        return null;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }

    static {
        fieldNameToType.put("base64Bytes".toLowerCase(), Body.Type.BINARY);
        fieldNameToType.put("json".toLowerCase(), Body.Type.JSON);
        fieldNameToType.put("jsonSchema".toLowerCase(), Body.Type.JSON_SCHEMA);
        fieldNameToType.put("jsonPath".toLowerCase(), Body.Type.JSON_PATH);
        fieldNameToType.put("parameters".toLowerCase(), Body.Type.PARAMETERS);
        fieldNameToType.put("regex".toLowerCase(), Body.Type.REGEX);
        fieldNameToType.put("string".toLowerCase(), Body.Type.STRING);
        fieldNameToType.put("xml".toLowerCase(), Body.Type.XML);
        fieldNameToType.put("xmlSchema".toLowerCase(), Body.Type.XML_SCHEMA);
        fieldNameToType.put("xpath".toLowerCase(), Body.Type.XPATH);
        MOCK_SERVER_LOGGER = new MockServerLogger(BodyDTODeserializer.class);
    }
}

