/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxyconfiguration;

import java.net.InetSocketAddress;
import org.mockserver.configuration.ConfigurationProperties;

public class ProxyConfiguration {
    private final Type type;
    private final InetSocketAddress proxyAddress;
    private final String username;
    private final String password;

    private ProxyConfiguration(Type type, InetSocketAddress proxyAddress, String username, String password) {
        this.type = type;
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    public static ProxyConfiguration proxyConfiguration() {
        String username = ConfigurationProperties.forwardProxyAuthenticationUsername();
        String password = ConfigurationProperties.forwardProxyAuthenticationPassword();
        InetSocketAddress httpProxySocketAddress = ConfigurationProperties.forwardHttpProxy();
        if (httpProxySocketAddress == null) {
            httpProxySocketAddress = ConfigurationProperties.httpProxy();
        }
        if (httpProxySocketAddress != null) {
            return ProxyConfiguration.proxyConfiguration(Type.HTTP, httpProxySocketAddress, username, password);
        }
        InetSocketAddress httpsProxySocketAddress = ConfigurationProperties.forwardHttpsProxy();
        if (httpsProxySocketAddress == null) {
            httpsProxySocketAddress = ConfigurationProperties.httpsProxy();
        }
        if (httpsProxySocketAddress != null) {
            return ProxyConfiguration.proxyConfiguration(Type.HTTPS, httpsProxySocketAddress, username, password);
        }
        InetSocketAddress socksProxySocketAddress = ConfigurationProperties.forwardSocksProxy();
        if (socksProxySocketAddress == null) {
            socksProxySocketAddress = ConfigurationProperties.socksProxy();
        }
        if (socksProxySocketAddress != null) {
            return ProxyConfiguration.proxyConfiguration(Type.SOCKS5, socksProxySocketAddress, username, password);
        }
        return null;
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address) {
        return ProxyConfiguration.proxyConfiguration(type, address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address) {
        return ProxyConfiguration.proxyConfiguration(type, address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address, String username, String password) {
        String[] addressParts = address.split(":");
        if (addressParts.length != 2) {
            throw new IllegalArgumentException("Proxy address must be in the format <host>:<ip>, for example 127.0.0.1:9090 or localhost:9090");
        }
        try {
            return ProxyConfiguration.proxyConfiguration(type, new InetSocketAddress(addressParts[0], Integer.parseInt(addressParts[1])), username, password);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Proxy address port \"" + addressParts[1] + "\" into an integer");
        }
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address, String username, String password) {
        return new ProxyConfiguration(type, address, username, password);
    }

    public Type getType() {
        return this.type;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static enum Type {
        HTTP,
        HTTPS,
        SOCKS5;

    }
}

