/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.mockserver.scheduler.Scheduler;

public class FileWatcher {
    private boolean running = true;

    public FileWatcher(String filePath, Runnable updatedHandler, Consumer<Throwable> errorHandler) throws Exception {
        Path directoryPath = Paths.get(filePath, new String[0]);
        Path fileName = directoryPath.getFileName();
        WatchService watchService = FileSystems.getDefault().newWatchService();
        directoryPath.getParent().register(watchService, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        new Scheduler.SchedulerThreadFactory(FileWatcher.class.getSimpleName()).newThread(() -> {
            while (this.isRunning()) {
                try {
                    WatchKey key = watchService.take();
                    if (!this.isRunning()) continue;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!(event.context() instanceof Path) || !((Path)event.context()).getFileName().equals(fileName)) continue;
                        TimeUnit.MILLISECONDS.sleep(100L);
                        updatedHandler.run();
                        break;
                    }
                    key.reset();
                }
                catch (Throwable throwable) {
                    errorHandler.accept(throwable);
                }
            }
        }).start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

