/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class HttpForwardActionResult {
    private final HttpRequest httpRequest;
    private final InetSocketAddress remoteAddress;
    private CompletableFuture<HttpResponse> httpResponse;
    private final Function<HttpResponse, HttpResponse> overrideHttpResponse;
    private final AtomicBoolean overrideHttpResponseApplied = new AtomicBoolean(false);

    HttpForwardActionResult(HttpRequest httpRequest, CompletableFuture<HttpResponse> httpResponse, Function<HttpResponse, HttpResponse> overrideHttpResponse) {
        this(httpRequest, httpResponse, overrideHttpResponse, null);
    }

    HttpForwardActionResult(HttpRequest httpRequest, CompletableFuture<HttpResponse> httpResponse, Function<HttpResponse, HttpResponse> overrideHttpResponse, InetSocketAddress remoteAddress) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.overrideHttpResponse = overrideHttpResponse;
        this.remoteAddress = remoteAddress;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public CompletableFuture<HttpResponse> getHttpResponse() {
        if (this.overrideHttpResponse == null) {
            return this.httpResponse;
        }
        if (this.overrideHttpResponseApplied.compareAndSet(false, true)) {
            this.httpResponse = this.httpResponse.thenApply(response -> {
                if (response != null) {
                    return this.overrideHttpResponse.apply((HttpResponse)response);
                }
                return null;
            });
        }
        return this.httpResponse;
    }

    public HttpForwardActionResult setHttpResponse(CompletableFuture<HttpResponse> httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

