/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.client.SocketCommunicationException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.HttpErrorActionHandler;
import org.mockserver.mock.action.HttpForwardActionHandler;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.mock.action.HttpForwardClassCallbackActionHandler;
import org.mockserver.mock.action.HttpForwardObjectCallbackActionHandler;
import org.mockserver.mock.action.HttpForwardTemplateActionHandler;
import org.mockserver.mock.action.HttpOverrideForwardedRequestActionHandler;
import org.mockserver.mock.action.HttpResponseActionHandler;
import org.mockserver.mock.action.HttpResponseClassCallbackActionHandler;
import org.mockserver.mock.action.HttpResponseObjectCallbackActionHandler;
import org.mockserver.mock.action.HttpResponseTemplateActionHandler;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.curl.HttpRequestToCurlSerializer;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class ActionHandler {
    public static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    private final HttpStateHandler httpStateHandler;
    private final Scheduler scheduler;
    private MockServerLogger mockServerLogger;
    private HttpResponseActionHandler httpResponseActionHandler;
    private HttpResponseTemplateActionHandler httpResponseTemplateActionHandler;
    private HttpResponseClassCallbackActionHandler httpResponseClassCallbackActionHandler;
    private HttpResponseObjectCallbackActionHandler httpResponseObjectCallbackActionHandler;
    private HttpForwardActionHandler httpForwardActionHandler;
    private HttpForwardTemplateActionHandler httpForwardTemplateActionHandler;
    private HttpForwardClassCallbackActionHandler httpForwardClassCallbackActionHandler;
    private HttpForwardObjectCallbackActionHandler httpForwardObjectCallbackActionHandler;
    private HttpOverrideForwardedRequestActionHandler httpOverrideForwardedRequestCallbackActionHandler;
    private HttpErrorActionHandler httpErrorActionHandler;
    private NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();
    private HttpRequestToCurlSerializer httpRequestToCurlSerializer;

    public ActionHandler(EventLoopGroup eventLoopGroup, HttpStateHandler httpStateHandler, ProxyConfiguration proxyConfiguration, NettySslContextFactory nettySslContextFactory) {
        this.httpStateHandler = httpStateHandler;
        this.scheduler = httpStateHandler.getScheduler();
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.httpRequestToCurlSerializer = new HttpRequestToCurlSerializer(this.mockServerLogger);
        this.httpClient = new NettyHttpClient(this.mockServerLogger, eventLoopGroup, proxyConfiguration, true, nettySslContextFactory);
    }

    public void processAction(HttpRequest request, ResponseWriter responseWriter, ChannelHandlerContext ctx, Set<String> localAddresses, boolean proxyingRequest, boolean synchronous) {
        boolean potentiallyHttpProxy;
        if (request.getHeaders() == null || !request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("received request:{}").setArguments(request));
        }
        Expectation expectation = this.httpStateHandler.firstMatchingExpectation(request);
        Runnable expectationPostProcessor = () -> this.httpStateHandler.postProcess(expectation);
        boolean bl = potentiallyHttpProxy = !StringUtils.isEmpty((CharSequence)request.getFirstHeader(HttpHeaderNames.HOST.toString())) && !localAddresses.contains(request.getFirstHeader(HttpHeaderNames.HOST.toString()));
        if (expectation != null && expectation.getAction() != null) {
            Action action = expectation.getAction();
            switch (action.getType()) {
                case RESPONSE: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpResponse response = this.getHttpResponseActionHandler().handle((HttpResponse)action);
                        this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case RESPONSE_TEMPLATE: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpResponse response = this.getHttpResponseTemplateActionHandler().handle((HttpTemplate)action, request);
                        this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case RESPONSE_CLASS_CALLBACK: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpResponse response = this.getHttpResponseClassCallbackActionHandler().handle((HttpClassCallback)action, request);
                        this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case RESPONSE_OBJECT_CALLBACK: {
                    this.scheduler.schedule(() -> this.getHttpResponseObjectCallbackActionHandler().handle(this, (HttpObjectCallback)action, request, responseWriter, synchronous, expectationPostProcessor), synchronous, action.getDelay());
                    break;
                }
                case FORWARD: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpForwardActionHandler().handle((HttpForward)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_TEMPLATE: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpForwardTemplateActionHandler().handle((HttpTemplate)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_CLASS_CALLBACK: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpForwardClassCallbackActionHandler().handle((HttpClassCallback)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_OBJECT_CALLBACK: {
                    this.scheduler.schedule(() -> this.getHttpForwardObjectCallbackActionHandler().handle(this, (HttpObjectCallback)action, request, responseWriter, synchronous, expectationPostProcessor), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_REPLACE: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpOverrideForwardedRequestCallbackActionHandler().handle((HttpOverrideForwardedRequest)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case ERROR: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        this.getHttpErrorActionHandler().handle((HttpError)action, ctx);
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_RESPONSE).setLogLevel(Level.INFO).setHttpRequest(request).setHttpError((HttpError)action).setMessageFormat("returning error:{}for request:{}for action:{}").setArguments(action, request, action));
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                }
            }
        } else if (CORSHeaders.isPreflightRequest(request) && (ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses())) {
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.INFO).setLogLevel(Level.INFO).setMessageFormat("returning CORS response for OPTIONS request"));
        } else if (proxyingRequest || potentiallyHttpProxy) {
            if (request.getHeaders() != null && request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("received \"x-forwarded-by\" header caused by exploratory HTTP proxy or proxy loop - falling back to no proxy:{}").setArguments(request));
                this.returnNotFound(responseWriter, request, null);
            } else {
                InetSocketAddress remoteAddress = ctx != null ? (InetSocketAddress)ctx.channel().attr(REMOTE_SOCKET).get() : null;
                HttpRequest clonedRequest = this.hopByHopHeaderFilter.onRequest(request).withHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue());
                HttpForwardActionResult responseFuture = new HttpForwardActionResult(clonedRequest, this.httpClient.sendRequest(clonedRequest, remoteAddress, potentiallyHttpProxy ? 1000 : ConfigurationProperties.socketConnectionTimeout()), null, remoteAddress);
                this.scheduler.submit(responseFuture, () -> {
                    try {
                        HttpResponse response = responseFuture.getHttpResponse().get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
                        if (response == null) {
                            response = HttpResponse.notFoundResponse();
                        }
                        if (response.containsHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
                            response.removeHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName());
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED_RESPONSE).setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse(HttpResponse.notFoundResponse()).setMessageFormat("no expectation for:{}returning response:{}").setArguments(request, HttpResponse.notFoundResponse()));
                        } else {
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.FORWARDED_REQUEST).setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse(response).setExpectation(request, response).setMessageFormat("returning response:{}for forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json:{}" + Character.NEW_LINE + Character.NEW_LINE + " in curl:{}").setArguments(response, request, this.httpRequestToCurlSerializer.toCurl(request, remoteAddress)));
                        }
                        responseWriter.writeResponse(request, response, false);
                    }
                    catch (SocketCommunicationException sce) {
                        this.returnNotFound(responseWriter, request, sce.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (potentiallyHttpProxy && ExceptionHandling.connectionException(throwable)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("failed to connect to proxied socket due to exploratory HTTP proxy for:{}due to:{}falling back to no proxy").setArguments(request, throwable.getCause()));
                            this.returnNotFound(responseWriter, request, null);
                        }
                        if (ExceptionHandling.sslHandshakeException(throwable)) {
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("TLS handshake exception while proxying request{}to remote address{}with channel" + (ctx != null ? String.valueOf(ctx.channel()) : "")).setArguments(request, remoteAddress).setThrowable(throwable));
                            this.returnNotFound(responseWriter, request, "TLS handshake exception while proxying request to remote address" + remoteAddress);
                        }
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat(throwable.getMessage()).setThrowable(throwable));
                        this.returnNotFound(responseWriter, request, throwable.getMessage());
                    }
                }, synchronous);
            }
        } else {
            this.returnNotFound(responseWriter, request, null);
        }
    }

    private void handleAnyException(HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Action action, Runnable processAction) {
        try {
            processAction.run();
        }
        catch (Throwable throwable) {
            this.writeResponseActionResponse(HttpResponse.notFoundResponse(), responseWriter, request, action, synchronous);
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat(throwable.getMessage()).setThrowable(throwable));
        }
    }

    void writeResponseActionResponse(HttpResponse response, ResponseWriter responseWriter, HttpRequest request, Action action, boolean synchronous) {
        this.scheduler.schedule(() -> {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_RESPONSE).setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse(response).setMessageFormat("returning response:{}for request:{}for action:{}").setArguments(response, request, action));
            responseWriter.writeResponse(request, response, false);
        }, synchronous, response.getDelay());
    }

    void executeAfterForwardActionResponse(HttpForwardActionResult responseFuture, Consumer<HttpResponse> command, boolean synchronous) {
        this.scheduler.submit(responseFuture, command, synchronous);
    }

    void writeForwardActionResponse(HttpForwardActionResult responseFuture, ResponseWriter responseWriter, HttpRequest request, Action action, boolean synchronous) {
        this.scheduler.submit(responseFuture, () -> {
            try {
                HttpResponse response = responseFuture.getHttpResponse().get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
                responseWriter.writeResponse(request, response, false);
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.FORWARDED_REQUEST).setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse(response).setExpectation(request, response).setMessageFormat("returning response:{}for forwarded request\n\n in json:{}\n\n in curl:{}for action:{}").setArguments(response, responseFuture.getHttpRequest(), this.httpRequestToCurlSerializer.toCurl(responseFuture.getHttpRequest(), responseFuture.getRemoteAddress()), action));
            }
            catch (Throwable throwable) {
                if (ExceptionHandling.connectionException(throwable)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("failed to connect to remote socket while forwarding request{}for action{}").setArguments(request, action).setThrowable(throwable));
                    this.returnNotFound(responseWriter, request, "failed to connect to remote socket while forwarding request");
                }
                if (ExceptionHandling.sslHandshakeException(throwable)) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("TLS handshake exception while forwarding request{}for action{}").setArguments(request, action).setThrowable(throwable));
                    this.returnNotFound(responseWriter, request, "TLS handshake exception while forwarding request");
                }
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat(throwable.getMessage()).setThrowable(throwable));
            }
        }, synchronous);
    }

    private void returnNotFound(ResponseWriter responseWriter, HttpRequest request, String error) {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
            response.withHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue());
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("no expectation for:{}returning response:{}").setArguments(request, HttpResponse.notFoundResponse()));
        } else if (StringUtils.isNotBlank((CharSequence)error)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED_RESPONSE).setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse(HttpResponse.notFoundResponse()).setMessageFormat("error:{}handling request:{}returning response:{}").setArguments(error, request, HttpResponse.notFoundResponse()));
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED_RESPONSE).setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse(HttpResponse.notFoundResponse()).setMessageFormat("no expectation for:{}returning response:{}").setArguments(request, HttpResponse.notFoundResponse()));
        }
        responseWriter.writeResponse(request, response, false);
    }

    private HttpResponseActionHandler getHttpResponseActionHandler() {
        if (this.httpResponseActionHandler == null) {
            this.httpResponseActionHandler = new HttpResponseActionHandler();
        }
        return this.httpResponseActionHandler;
    }

    private HttpResponseTemplateActionHandler getHttpResponseTemplateActionHandler() {
        if (this.httpResponseTemplateActionHandler == null) {
            this.httpResponseTemplateActionHandler = new HttpResponseTemplateActionHandler(this.mockServerLogger);
        }
        return this.httpResponseTemplateActionHandler;
    }

    private HttpResponseClassCallbackActionHandler getHttpResponseClassCallbackActionHandler() {
        if (this.httpResponseClassCallbackActionHandler == null) {
            this.httpResponseClassCallbackActionHandler = new HttpResponseClassCallbackActionHandler(this.mockServerLogger);
        }
        return this.httpResponseClassCallbackActionHandler;
    }

    private HttpResponseObjectCallbackActionHandler getHttpResponseObjectCallbackActionHandler() {
        if (this.httpResponseObjectCallbackActionHandler == null) {
            this.httpResponseObjectCallbackActionHandler = new HttpResponseObjectCallbackActionHandler(this.httpStateHandler);
        }
        return this.httpResponseObjectCallbackActionHandler;
    }

    private HttpForwardActionHandler getHttpForwardActionHandler() {
        if (this.httpForwardActionHandler == null) {
            this.httpForwardActionHandler = new HttpForwardActionHandler(this.mockServerLogger, this.httpClient);
        }
        return this.httpForwardActionHandler;
    }

    private HttpForwardTemplateActionHandler getHttpForwardTemplateActionHandler() {
        if (this.httpForwardTemplateActionHandler == null) {
            this.httpForwardTemplateActionHandler = new HttpForwardTemplateActionHandler(this.mockServerLogger, this.httpClient);
        }
        return this.httpForwardTemplateActionHandler;
    }

    private HttpForwardClassCallbackActionHandler getHttpForwardClassCallbackActionHandler() {
        if (this.httpForwardClassCallbackActionHandler == null) {
            this.httpForwardClassCallbackActionHandler = new HttpForwardClassCallbackActionHandler(this.mockServerLogger, this.httpClient);
        }
        return this.httpForwardClassCallbackActionHandler;
    }

    private HttpForwardObjectCallbackActionHandler getHttpForwardObjectCallbackActionHandler() {
        if (this.httpForwardObjectCallbackActionHandler == null) {
            this.httpForwardObjectCallbackActionHandler = new HttpForwardObjectCallbackActionHandler(this.httpStateHandler, this.httpClient);
        }
        return this.httpForwardObjectCallbackActionHandler;
    }

    private HttpOverrideForwardedRequestActionHandler getHttpOverrideForwardedRequestCallbackActionHandler() {
        if (this.httpOverrideForwardedRequestCallbackActionHandler == null) {
            this.httpOverrideForwardedRequestCallbackActionHandler = new HttpOverrideForwardedRequestActionHandler(this.mockServerLogger, this.httpClient);
        }
        return this.httpOverrideForwardedRequestCallbackActionHandler;
    }

    private HttpErrorActionHandler getHttpErrorActionHandler() {
        if (this.httpErrorActionHandler == null) {
            this.httpErrorActionHandler = new HttpErrorActionHandler();
        }
        return this.httpErrorActionHandler;
    }
}

