/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.model.HttpResponse;

@ChannelHandler.Sharable
public class HttpClientHandler
extends SimpleChannelInboundHandler<HttpResponse> {
    HttpClientHandler() {
        super(false);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpResponse response) {
        ((CompletableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).complete(response);
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isNotSslException(cause)) {
            cause.printStackTrace();
        }
        ((CompletableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).completeExceptionally(cause);
        ctx.close();
    }

    private boolean isNotSslException(Throwable cause) {
        return !(cause.getCause() instanceof SSLException) && !(cause instanceof DecoderException | cause instanceof NotSslRecordException);
    }
}

