/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.response;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.LogEventBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;

public class HttpResponseDTOSerializer
extends StdSerializer<HttpResponseDTO> {
    public HttpResponseDTOSerializer() {
        super(HttpResponseDTO.class);
    }

    public void serialize(HttpResponseDTO httpResponseDTO, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        BodyWithContentTypeDTO body;
        jgen.writeStartObject();
        if (httpResponseDTO.getStatusCode() != null) {
            jgen.writeObjectField("statusCode", (Object)httpResponseDTO.getStatusCode());
        }
        if (httpResponseDTO.getReasonPhrase() != null) {
            jgen.writeObjectField("reasonPhrase", (Object)httpResponseDTO.getReasonPhrase());
        }
        if (httpResponseDTO.getHeaders() != null && !httpResponseDTO.getHeaders().isEmpty()) {
            jgen.writeObjectField("headers", (Object)httpResponseDTO.getHeaders());
        }
        if (httpResponseDTO.getCookies() != null && !httpResponseDTO.getCookies().isEmpty()) {
            jgen.writeObjectField("cookies", (Object)httpResponseDTO.getCookies());
        }
        if ((body = httpResponseDTO.getBody()) != null) {
            if (body instanceof StringBodyDTO && !((StringBodyDTO)body).getString().isEmpty()) {
                jgen.writeObjectField("body", (Object)body);
            } else if (body instanceof JsonBodyDTO && !((JsonBodyDTO)body).getJson().isEmpty()) {
                jgen.writeObjectField("body", (Object)((JsonBodyDTO)body).getJson());
            } else if (body instanceof XmlBodyDTO && !((XmlBodyDTO)body).getXml().isEmpty()) {
                jgen.writeObjectField("body", (Object)((XmlBodyDTO)body).getXml());
            } else if (body instanceof ParameterBodyDTO && !((ParameterBodyDTO)body).getParameters().isEmpty()) {
                jgen.writeObjectField("body", (Object)((ParameterBodyDTO)body).buildObject().toString());
            } else if (body instanceof BinaryBodyDTO) {
                jgen.writeObjectField("body", (Object)body);
            } else if (body instanceof LogEventBodyDTO) {
                jgen.writeObjectField("body", (Object)body);
            }
        }
        if (httpResponseDTO.getDelay() != null) {
            jgen.writeObjectField("delay", (Object)httpResponseDTO.getDelay());
        }
        if (httpResponseDTO.getConnectionOptions() != null) {
            jgen.writeObjectField("connectionOptions", (Object)httpResponseDTO.getConnectionOptions());
        }
        jgen.writeEndObject();
    }
}

