/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.collections;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.KeysToMultiValues;
import org.mockserver.model.NottableString;

public abstract class KeysToMultiValuesSerializer<T extends KeysToMultiValues<? extends KeyToMultiValue, T>>
extends StdSerializer<T> {
    KeysToMultiValuesSerializer(Class<T> valueClass) {
        super(valueClass);
    }

    public void serialize(T collection, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        for (NottableString key : ((KeysToMultiValues)collection).keySet()) {
            jgen.writeFieldName(NottableString.serialiseNottableString(key));
            List<NottableString> values = ((KeysToMultiValues)collection).getValues(key);
            jgen.writeStartArray(values.size());
            for (NottableString nottableString : values) {
                jgen.writeString(NottableString.serialiseNottableString(nottableString));
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

