/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpRequestAndHttpResponseDTO;
import org.mockserver.validator.jsonschema.JsonSchemaHttpRequestAndHttpResponseValidator;
import org.slf4j.event.Level;

public class HttpRequestAndHttpResponseSerializer
implements Serializer<HttpRequestAndHttpResponse> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaHttpRequestAndHttpResponseValidator jsonSchemaHttpRequestAndHttpResponseValidator;

    public HttpRequestAndHttpResponseSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.jsonSchemaHttpRequestAndHttpResponseValidator = JsonSchemaHttpRequestAndHttpResponseValidator.jsonSchemaHttpRequestAndHttpResponseValidator(mockServerLogger);
    }

    @Override
    public String serialize(HttpRequestAndHttpResponse httpRequestAndHttpResponse) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new HttpRequestAndHttpResponseDTO(httpRequestAndHttpResponse));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + httpRequestAndHttpResponse).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + httpRequestAndHttpResponse, e);
        }
    }

    @Override
    public String serialize(List<HttpRequestAndHttpResponse> httpRequests) {
        return this.serialize(httpRequests.toArray(new HttpRequestAndHttpResponse[0]));
    }

    @Override
    public String serialize(HttpRequestAndHttpResponse ... httpRequests) {
        try {
            if (httpRequests != null && httpRequests.length > 0) {
                HttpRequestAndHttpResponseDTO[] httpRequestDTOs = new HttpRequestAndHttpResponseDTO[httpRequests.length];
                for (int i = 0; i < httpRequests.length; ++i) {
                    httpRequestDTOs[i] = new HttpRequestAndHttpResponseDTO(httpRequests[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)httpRequestDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + Arrays.asList(httpRequests)).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + Arrays.asList(httpRequests), e);
        }
    }

    @Override
    public HttpRequestAndHttpResponse deserialize(String jsonHttpRequest) {
        String validationErrors;
        if (StringUtils.isBlank((CharSequence)jsonHttpRequest)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request is required but value was \"" + jsonHttpRequest + "\"");
        }
        if (jsonHttpRequest.contains("\"httpRequestAndHttpResponse\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpRequest);
                if (jsonNode.has("httpRequestAndHttpResponse")) {
                    jsonHttpRequest = jsonNode.get("httpRequestAndHttpResponse").toString();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for HttpRequestAndHttpResponse").setArguments(jsonHttpRequest).setThrowable(e));
                throw new RuntimeException("Exception while parsing [" + jsonHttpRequest + "] for HttpRequestAndHttpResponse", e);
            }
        }
        if ((validationErrors = this.jsonSchemaHttpRequestAndHttpResponseValidator.isValid(jsonHttpRequest)).isEmpty()) {
            HttpRequestAndHttpResponse httpRequestAndHttpResponse = null;
            try {
                HttpRequestAndHttpResponseDTO httpRequestDTO = (HttpRequestAndHttpResponseDTO)this.objectMapper.readValue(jsonHttpRequest, HttpRequestAndHttpResponseDTO.class);
                if (httpRequestDTO != null) {
                    httpRequestAndHttpResponse = httpRequestDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for HttpRequestAndHttpResponse").setArguments(jsonHttpRequest).setThrowable(e));
                throw new RuntimeException("Exception while parsing [" + jsonHttpRequest + "] for HttpRequestAndHttpResponse", e);
            }
            return httpRequestAndHttpResponse;
        }
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(null).setMessageFormat("validation failed:{}request:{}").setArguments(validationErrors, jsonHttpRequest));
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<HttpRequestAndHttpResponse> supportsType() {
        return HttpRequestAndHttpResponse.class;
    }

    public HttpRequestAndHttpResponse[] deserializeArray(String jsonHttpRequests) {
        ArrayList<HttpRequestAndHttpResponse> httpRequests = new ArrayList<HttpRequestAndHttpResponse>();
        if (StringUtils.isBlank((CharSequence)jsonHttpRequests)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or request array is required but value was \"" + jsonHttpRequests + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.returnJSONObjects(jsonHttpRequests);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                httpRequests.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequests.toArray(new HttpRequestAndHttpResponse[0]);
    }
}

