/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.client.HttpClientConnectionHandler;
import org.mockserver.client.HttpClientHandler;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.codec.MockServerClientCodec;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.proxy.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final HttpClientConnectionHandler httpClientConnectionHandler;
    private final HttpClientHandler httpClientHandler;
    private final ProxyConfiguration proxyConfiguration;

    HttpClientInitializer(ProxyConfiguration proxyConfiguration, MockServerLogger mockServerLogger) {
        this.proxyConfiguration = proxyConfiguration;
        this.mockServerLogger = mockServerLogger;
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionHandler();
    }

    public void initChannel(SocketChannel channel) {
        boolean secure;
        ChannelPipeline pipeline = channel.pipeline();
        boolean bl = secure = channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && (Boolean)channel.attr(NettyHttpClient.SECURE).get() != false;
        if (this.proxyConfiguration != null) {
            if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.HTTPS && secure) {
                if (this.proxyConfiguration.getUsername() != null && this.proxyConfiguration.getPassword() != null) {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress(), this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress())});
                }
            } else if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.SOCKS5) {
                if (this.proxyConfiguration.getUsername() != null && this.proxyConfiguration.getPassword() != null) {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress(), this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress())});
                }
            }
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientConnectionHandler});
        if (secure) {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
            pipeline.addLast(new ChannelHandler[]{new NettySslContextFactory(this.mockServerLogger).createClientSslContext().newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort())});
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("NettyHttpClient -->")});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerClientCodec(this.mockServerLogger)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }
}

