/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.serialization.java.ToJavaSerializer;

public class ConnectionOptionsToJavaSerializer
implements ToJavaSerializer<ConnectionOptions> {
    @Override
    public String serialize(int numberOfSpacesToIndent, ConnectionOptions connectionOptions) {
        StringBuffer output = new StringBuffer();
        if (connectionOptions != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("connectionOptions()");
            if (connectionOptions.getSuppressContentLengthHeader() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withSuppressContentLengthHeader(").append(connectionOptions.getSuppressContentLengthHeader()).append(")");
            }
            if (connectionOptions.getContentLengthHeaderOverride() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withContentLengthHeaderOverride(").append(connectionOptions.getContentLengthHeaderOverride()).append(")");
            }
            if (connectionOptions.getSuppressConnectionHeader() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withSuppressConnectionHeader(").append(connectionOptions.getSuppressConnectionHeader()).append(")");
            }
            if (connectionOptions.getKeepAliveOverride() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withKeepAliveOverride(").append(connectionOptions.getKeepAliveOverride()).append(")");
            }
            if (connectionOptions.getCloseSocket() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCloseSocket(").append(connectionOptions.getCloseSocket()).append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

