/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;

public class ParameterBody
extends BodyWithContentType<List<Parameter>> {
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.FORM_DATA;
    private Parameters parameters = new Parameters(new Parameter[0]);

    public ParameterBody(Parameter ... parameters) {
        this((Parameters)new Parameters(new Parameter[0]).withEntries(parameters));
    }

    public ParameterBody(List<Parameter> parameters) {
        this((Parameters)new Parameters(new Parameter[0]).withEntries(parameters));
    }

    public ParameterBody(Parameters parameters) {
        super(Body.Type.PARAMETERS, DEFAULT_CONTENT_TYPE);
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    public static ParameterBody params(Parameter ... parameters) {
        return new ParameterBody(parameters);
    }

    public static ParameterBody params(List<Parameter> parameters) {
        return new ParameterBody(parameters);
    }

    public Parameters getValue() {
        return this.parameters;
    }

    @Override
    public String toString() {
        StringBuilder body = new StringBuilder();
        List bodyParameters = this.parameters.getEntries();
        for (int i = 0; i < bodyParameters.size(); ++i) {
            Parameter parameter = (Parameter)bodyParameters.get(i);
            if (parameter.getValues().isEmpty()) {
                body.append(parameter.getName().getValue());
                body.append('=');
            } else {
                List<NottableString> values = parameter.getValues();
                for (int j = 0; j < values.size(); ++j) {
                    String value = values.get(j).getValue();
                    body.append(parameter.getName().getValue());
                    body.append('=');
                    try {
                        body.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new RuntimeException("UnsupportedEncodingException while encoding body parameters for " + this.parameters, uee);
                    }
                    if (j >= values.size() - 1) continue;
                    body.append('&');
                }
            }
            if (i >= bodyParameters.size() - 1) continue;
            body.append('&');
        }
        return body.toString();
    }
}

