/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class KeysToMultiValues<T extends KeyToMultiValue, K extends KeysToMultiValues>
extends ObjectWithJsonToString {
    private final ListMultimap<NottableString, NottableString> listMultimap = LinkedListMultimap.create();
    private final K k = this;

    private CaseInsensitiveRegexMultiMap toCaseInsensitiveRegexMultiMap(MockServerLogger mockServerLogger, List<T> entries, boolean controlPlaneMatcher) {
        CaseInsensitiveRegexMultiMap caseInsensitiveRegexMultiMap = new CaseInsensitiveRegexMultiMap(mockServerLogger, controlPlaneMatcher);
        if (entries != null) {
            for (KeyToMultiValue keyToMultiValue : entries) {
                for (NottableString value : keyToMultiValue.getValues()) {
                    caseInsensitiveRegexMultiMap.put(keyToMultiValue.getName(), value);
                }
            }
        }
        return caseInsensitiveRegexMultiMap;
    }

    public abstract T build(NottableString var1, Collection<NottableString> var2);

    public K withEntries(Map<String, List<String>> entries) {
        this.listMultimap.clear();
        for (String name : entries.keySet()) {
            for (String value : entries.get(name)) {
                this.withEntry(name, value);
            }
        }
        return this.k;
    }

    public K withEntries(List<T> entries) {
        this.listMultimap.clear();
        if (entries != null) {
            for (KeyToMultiValue entry : entries) {
                this.withEntry(entry);
            }
        }
        return this.k;
    }

    @SafeVarargs
    public final K withEntries(T ... entries) {
        if (ArrayUtils.isNotEmpty((Object[])entries)) {
            this.withEntries(Arrays.asList(entries));
        }
        return this.k;
    }

    public K withEntry(T entry) {
        if (((KeyToMultiValue)entry).getValues().isEmpty()) {
            this.listMultimap.put((Object)((KeyToMultiValue)entry).getName(), null);
        } else {
            this.listMultimap.putAll((Object)((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return this.k;
    }

    public K withEntry(String name, String ... values) {
        if (values == null || values.length == 0) {
            this.listMultimap.put((Object)NottableString.string(name), null);
        } else {
            this.listMultimap.putAll((Object)NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public K withEntry(String name, List<String> values) {
        if (values == null || values.size() == 0) {
            this.listMultimap.put((Object)NottableString.string(name), null);
        } else {
            this.listMultimap.putAll((Object)NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public K withEntry(NottableString name, List<NottableString> values) {
        if (values != null) {
            this.listMultimap.putAll((Object)name, values);
        }
        return this.k;
    }

    public K withEntry(NottableString name, NottableString ... values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            this.withEntry(name, Arrays.asList(values));
        }
        return this.k;
    }

    public K remove(String name) {
        for (NottableString key : this.listMultimap.keySet().toArray(new NottableString[0])) {
            if (!key.equalsIgnoreCase(name)) continue;
            this.listMultimap.removeAll((Object)key);
        }
        return this.k;
    }

    public K remove(NottableString name) {
        for (NottableString key : this.listMultimap.keySet().toArray(new NottableString[0])) {
            if (!key.equalsIgnoreCase(name)) continue;
            this.listMultimap.removeAll((Object)key);
        }
        return this.k;
    }

    K replaceEntry(T entry) {
        if (entry != null) {
            this.remove(((KeyToMultiValue)entry).getName());
            this.listMultimap.putAll((Object)((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return this.k;
    }

    K replaceEntry(String name, String ... values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            this.remove(name);
            this.listMultimap.putAll((Object)NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public List<T> getEntries() {
        if (!this.isEmpty()) {
            ArrayList<T> headers = new ArrayList<T>();
            for (NottableString nottableString : this.listMultimap.keySet().toArray(new NottableString[0])) {
                headers.add(this.build(nottableString, this.listMultimap.get((Object)nottableString)));
            }
            return headers;
        }
        return Collections.emptyList();
    }

    public Multimap<NottableString, NottableString> getMultimap() {
        return this.listMultimap;
    }

    public List<String> getValues(String name) {
        if (!this.isEmpty() && name != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (NottableString key : this.listMultimap.keySet().toArray(new NottableString[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                values.addAll(NottableString.serialiseNottableString(this.listMultimap.get((Object)key)));
            }
            return values;
        }
        return Collections.emptyList();
    }

    String getFirstValue(String name) {
        if (!this.isEmpty()) {
            for (NottableString key : this.listMultimap.keySet().toArray(new NottableString[0])) {
                List nottableStrings;
                if (key == null || !key.equalsIgnoreCase(name) || (nottableStrings = this.listMultimap.get((Object)key)).isEmpty() || nottableStrings.get(0) == null) continue;
                return ((NottableString)nottableStrings.get(0)).getValue();
            }
        }
        return "";
    }

    public boolean containsEntry(String name) {
        if (!this.isEmpty()) {
            for (NottableString key : this.listMultimap.keySet().toArray(new NottableString[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsEntry(String name, String value) {
        return this.containsEntry(NottableString.string(name), NottableString.string(value));
    }

    boolean containsEntry(NottableString name, NottableString value) {
        if (!this.isEmpty() && name != null && value != null) {
            for (NottableString entryKey : this.listMultimap.keySet().toArray(new NottableString[0])) {
                List nottableStrings;
                if (entryKey == null || !entryKey.equalsIgnoreCase(name) || (nottableStrings = this.listMultimap.get((Object)entryKey)) == null) continue;
                for (NottableString entryValue : nottableStrings.toArray(new NottableString[0])) {
                    if (!value.equalsIgnoreCase(entryValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public CaseInsensitiveRegexMultiMap toCaseInsensitiveRegexMultiMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        return this.toCaseInsensitiveRegexMultiMap(mockServerLogger, this.getEntries(), controlPlaneMatcher);
    }

    public boolean isEmpty() {
        return this.listMultimap.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysToMultiValues)) {
            return false;
        }
        KeysToMultiValues that = (KeysToMultiValues)o;
        return Objects.equals(this.listMultimap, that.listMultimap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listMultimap);
    }
}

