/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.scheduler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockserver.client.netty.SocketCommunicationException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.Delay;

public class Scheduler {
    private ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(this.poolSize(), new ThreadPoolExecutor.CallerRunsPolicy());

    private int poolSize() {
        return Math.max(2, Runtime.getRuntime().availableProcessors() * 2);
    }

    public synchronized void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.scheduler = null;
        }
    }

    private synchronized ScheduledExecutorService getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(this.poolSize(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return this.scheduler;
    }

    public void schedule(Runnable command, boolean synchronous, Delay ... delays) {
        Delay delay = this.addDelays(delays);
        if (synchronous) {
            if (delay != null) {
                delay.applyDelay();
            }
            command.run();
        } else if (delay != null) {
            this.getScheduler().schedule(command, delay.getValue(), delay.getTimeUnit());
        } else {
            command.run();
        }
    }

    private Delay addDelays(Delay ... delays) {
        if (delays == null || delays.length == 0) {
            return null;
        }
        if (delays.length == 1) {
            return delays[0];
        }
        if (delays.length == 2 && delays[0] == delays[1]) {
            return delays[0];
        }
        long timeInMilliseconds = 0L;
        for (Delay delay : delays) {
            if (delay == null) continue;
            timeInMilliseconds += delay.getTimeUnit().toMillis(delay.getValue());
        }
        return new Delay(TimeUnit.MILLISECONDS, timeInMilliseconds);
    }

    public void submit(Runnable command) {
        this.submit(command, false);
    }

    public void submit(Runnable command, boolean synchronous) {
        if (synchronous) {
            command.run();
        } else {
            this.getScheduler().schedule(command, 0L, TimeUnit.NANOSECONDS);
        }
    }

    public void submit(HttpForwardActionResult future, Runnable command, boolean synchronous) {
        if (future != null) {
            if (synchronous) {
                try {
                    future.getHttpResponse().get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.getHttpResponse().setException((Throwable)new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException | ExecutionException ex) {
                    future.getHttpResponse().setException((Throwable)ex);
                }
                command.run();
            } else {
                future.getHttpResponse().addListener(command, (Executor)this.getScheduler());
            }
        }
    }
}

