/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import ch.qos.logback.classic.Level;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerLogger {
    public static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger();
    private final boolean auditEnabled = !ConfigurationProperties.disableRequestAudit();
    private final boolean logEnabled = !ConfigurationProperties.disableSystemOut();
    private final Logger logger;
    private final HttpStateHandler httpStateHandler;

    public MockServerLogger() {
        this(MockServerLogger.class);
    }

    public MockServerLogger(Class loggerClass) {
        this(LoggerFactory.getLogger((Class)loggerClass), null);
    }

    public MockServerLogger(Logger logger, @Nullable HttpStateHandler httpStateHandler) {
        this.logger = logger;
        this.httpStateHandler = httpStateHandler;
    }

    public static void setRootLogLevel(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            if (logger instanceof ch.qos.logback.classic.Logger) {
                ((ch.qos.logback.classic.Logger)logger).setLevel(Level.valueOf((String)System.getProperty("root.logLevel", "WARN")));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void trace(String message, Object ... arguments) {
        this.trace(null, message, arguments);
    }

    public void trace(HttpRequest request, String message, Object ... arguments) {
        if (this.isEnabled(org.slf4j.event.Level.TRACE)) {
            this.addLogEvents(MessageLogEntry.LogMessageType.TRACE, org.slf4j.event.Level.TRACE, request, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.trace(logMessage);
            }
        }
    }

    public void debug(MessageLogEntry.LogMessageType type, String message, Object ... arguments) {
        this.debug(type, null, message, arguments);
    }

    public void debug(MessageLogEntry.LogMessageType type, HttpRequest request, String message, Object ... arguments) {
        if (this.isEnabled(org.slf4j.event.Level.DEBUG)) {
            this.addLogEvents(type, org.slf4j.event.Level.DEBUG, request, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.debug(logMessage);
            }
        }
    }

    public void info(MessageLogEntry.LogMessageType type, String message, Object ... arguments) {
        this.info(type, (HttpRequest)null, message, arguments);
    }

    public void info(MessageLogEntry.LogMessageType type, HttpRequest request, String message, Object ... arguments) {
        this.info(type, (List<HttpRequest>)ImmutableList.of((Object)(request != null ? request : HttpRequest.request())), message, arguments);
    }

    public void info(MessageLogEntry.LogMessageType type, List<HttpRequest> requests, String message, Object ... arguments) {
        if (this.isEnabled(org.slf4j.event.Level.INFO)) {
            this.addLogEvents(type, org.slf4j.event.Level.INFO, requests, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.info(logMessage);
            }
        }
    }

    public void warn(String message) {
        this.warn((HttpRequest)null, message, new Object[0]);
    }

    public void warn(String message, Object ... arguments) {
        this.warn(null, message, arguments);
    }

    public void warn(@Nullable HttpRequest request, String message, Object ... arguments) {
        if (this.isEnabled(org.slf4j.event.Level.WARN)) {
            this.addLogEvents(MessageLogEntry.LogMessageType.WARN, org.slf4j.event.Level.WARN, request, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.error(logMessage);
            }
        }
    }

    public void error(String message, Throwable throwable) {
        this.error((HttpRequest)null, throwable, message, new Object[0]);
    }

    public void error(String message, Object ... arguments) {
        this.error(null, message, arguments);
    }

    public void error(@Nullable HttpRequest request, String message, Object ... arguments) {
        this.error(request, null, message, arguments);
    }

    public void error(@Nullable HttpRequest request, Throwable throwable, String message, Object ... arguments) {
        this.error((List<HttpRequest>)ImmutableList.of((Object)(request != null ? request : HttpRequest.request())), throwable, message, arguments);
    }

    public void error(List<HttpRequest> requests, Throwable throwable, String message, Object ... arguments) {
        if (this.isEnabled(org.slf4j.event.Level.ERROR)) {
            this.addLogEvents(MessageLogEntry.LogMessageType.EXCEPTION, org.slf4j.event.Level.ERROR, requests, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.error(logMessage, throwable);
            }
        }
    }

    private void addLogEvents(MessageLogEntry.LogMessageType type, org.slf4j.event.Level logLeveL, @Nullable HttpRequest request, String message, Object ... arguments) {
        if (this.auditEnabled && this.httpStateHandler != null) {
            this.httpStateHandler.log(new MessageLogEntry(type, logLeveL, request, message, arguments));
        }
    }

    private void addLogEvents(MessageLogEntry.LogMessageType type, org.slf4j.event.Level logLeveL, List<HttpRequest> requests, String message, Object ... arguments) {
        if (this.auditEnabled && this.httpStateHandler != null) {
            this.httpStateHandler.log(new MessageLogEntry(type, logLeveL, requests, message, arguments));
        }
    }

    public boolean isEnabled(org.slf4j.event.Level level) {
        return level.toInt() >= ConfigurationProperties.logLevel().toInt();
    }

    static {
        MockServerLogger.setRootLogLevel("io.netty");
        MockServerLogger.setRootLogLevel("org.apache.velocity");
        Logger mockServerLogger = LoggerFactory.getLogger((String)"org.mockserver");
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            if (mockServerLogger instanceof ch.qos.logback.classic.Logger) {
                ((ch.qos.logback.classic.Logger)mockServerLogger).setLevel(Level.valueOf((String)System.getProperty("mockserver.logLevel", ConfigurationProperties.logLevel().name())));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

