/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.util.UUID;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.callback.WebSocketResponseCallback;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;

public class HttpResponseObjectCallbackActionHandler {
    private final MockServerLogger logFormatter;
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpResponseObjectCallbackActionHandler(HttpStateHandler httpStateHandler) {
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
        this.logFormatter = httpStateHandler.getMockServerLogger();
    }

    public void handle(final HttpObjectCallback httpObjectCallback, final HttpRequest request, final ResponseWriter responseWriter) {
        String clientId = httpObjectCallback.getClientId();
        String webSocketCorrelationId = UUID.randomUUID().toString();
        this.webSocketClientRegistry.registerCallbackHandler(webSocketCorrelationId, new WebSocketResponseCallback(){

            @Override
            public void handle(HttpResponse response) {
                responseWriter.writeResponse(request, response.removeHeader("WebSocketCorrelationId"), false);
                HttpResponseObjectCallbackActionHandler.this.logFormatter.info(MessageLogEntry.LogMessageType.EXPECTATION_RESPONSE, request, "returning response:{}for request:{}for action:{}", response, request, httpObjectCallback);
            }
        });
        this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId));
    }
}

