/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import com.google.common.util.concurrent.SettableFuture;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.HttpForwardAction;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class HttpForwardTemplateActionHandler
extends HttpForwardAction {
    private JavaScriptTemplateEngine javaScriptTemplateEngine;
    private VelocityTemplateEngine velocityTemplateEngine;

    public HttpForwardTemplateActionHandler(MockServerLogger logFormatter, NettyHttpClient httpClient) {
        super(logFormatter, httpClient);
        this.javaScriptTemplateEngine = new JavaScriptTemplateEngine(logFormatter);
        this.velocityTemplateEngine = new VelocityTemplateEngine(logFormatter);
    }

    public SettableFuture<HttpResponse> handle(HttpTemplate httpTemplate, HttpRequest originalRequest) {
        HttpRequest templatedRequest;
        TemplateEngine templateEngine = null;
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.velocityTemplateEngine;
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.javaScriptTemplateEngine;
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedRequest = (HttpRequest)templateEngine.executeTemplate(httpTemplate.getTemplate(), originalRequest, HttpRequestDTO.class)) != null) {
            return this.sendRequest(templatedRequest, null);
        }
        return this.notFoundFuture();
    }
}

