/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import com.google.common.util.concurrent.SettableFuture;
import java.util.UUID;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.callback.WebSocketRequestCallback;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.HttpForwardAction;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;

public class HttpForwardObjectCallbackActionHandler
extends HttpForwardAction {
    private final MockServerLogger logFormatter;
    private final Scheduler scheduler;
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpForwardObjectCallbackActionHandler(HttpStateHandler httpStateHandler, NettyHttpClient httpClient) {
        super(httpStateHandler.getMockServerLogger(), httpClient);
        this.scheduler = httpStateHandler.getScheduler();
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
        this.logFormatter = httpStateHandler.getMockServerLogger();
    }

    public void handle(final HttpObjectCallback httpObjectCallback, HttpRequest request, final ResponseWriter responseWriter, final boolean synchronous) {
        String clientId = httpObjectCallback.getClientId();
        String webSocketCorrelationId = UUID.randomUUID().toString();
        this.webSocketClientRegistry.registerCallbackHandler(webSocketCorrelationId, new WebSocketRequestCallback(){

            @Override
            public void handle(final HttpRequest request) {
                final SettableFuture<HttpResponse> responseFuture = HttpForwardObjectCallbackActionHandler.this.sendRequest(request.removeHeader("WebSocketCorrelationId"), null);
                HttpForwardObjectCallbackActionHandler.this.scheduler.submit(responseFuture, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HttpResponse response = (HttpResponse)responseFuture.get();
                            responseWriter.writeResponse(request, response, false);
                            HttpForwardObjectCallbackActionHandler.this.logFormatter.info(MessageLogEntry.LogMessageType.EXPECTATION_RESPONSE, request, "returning response:{}for request:{}for action:{}", response, request, httpObjectCallback);
                        }
                        catch (Exception ex) {
                            HttpForwardObjectCallbackActionHandler.this.logFormatter.error(request, (Throwable)ex, ex.getMessage(), new Object[0]);
                        }
                    }
                }, synchronous);
            }
        });
        this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId));
    }
}

