/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.HttpForwardAction;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class HttpForwardClassCallbackActionHandler
extends HttpForwardAction {
    public HttpForwardClassCallbackActionHandler(MockServerLogger mockServerLogger, NettyHttpClient httpClient) {
        super(mockServerLogger, httpClient);
    }

    public SettableFuture<HttpResponse> handle(HttpClassCallback httpClassCallback, HttpRequest request) {
        return this.invokeCallbackMethod(httpClassCallback, request);
    }

    private ExpectationForwardCallback instantiateCallback(HttpClassCallback httpClassCallback) {
        try {
            Class<?> expectationResponseCallbackClass = Class.forName(httpClassCallback.getCallbackClass());
            if (ExpectationForwardCallback.class.isAssignableFrom(expectationResponseCallbackClass)) {
                Constructor<?> constructor = expectationResponseCallbackClass.getConstructor(new Class[0]);
                return (ExpectationForwardCallback)constructor.newInstance(new Object[0]);
            }
            this.mockServerLogger.error(httpClassCallback.getCallbackClass() + " does not implement " + ExpectationForwardCallback.class.getCanonicalName() + " which required for forwarded requests generated from a class callback", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.mockServerLogger.error("ClassNotFoundException - while trying to instantiate ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"", e);
        }
        catch (NoSuchMethodException e) {
            this.mockServerLogger.error("NoSuchMethodException - while trying to create default constructor on ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.mockServerLogger.error("InvocationTargetException - while trying to execute default constructor on ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"", e);
        }
        return null;
    }

    private SettableFuture<HttpResponse> invokeCallbackMethod(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationForwardCallback expectationForwardCallback = this.instantiateCallback(httpClassCallback);
            if (expectationForwardCallback != null) {
                return this.sendRequest(expectationForwardCallback.handle(httpRequest), null);
            }
            return this.notFoundFuture();
        }
        return this.notFoundFuture();
    }
}

