/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.JsonBody;

public class JsonBodySerializer
extends StdSerializer<JsonBody> {
    public JsonBodySerializer() {
        super(JsonBody.class);
    }

    public void serialize(JsonBody jsonBody, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (jsonBody.getNot() != null && jsonBody.getNot().booleanValue()) {
            jgen.writeBooleanField("not", jsonBody.getNot().booleanValue());
        }
        if (jsonBody.getContentType() != null && !jsonBody.getContentType().equals(JsonBody.DEFAULT_CONTENT_TYPE.toString())) {
            jgen.writeStringField("contentType", jsonBody.getContentType());
        }
        jgen.writeStringField("type", jsonBody.getType().name());
        jgen.writeStringField("json", jsonBody.getValue());
        if (jsonBody.getMatchType() != JsonBody.DEFAULT_MATCH_TYPE) {
            jgen.writeStringField("matchType", jsonBody.getMatchType().name());
        }
        jgen.writeEndObject();
    }
}

