/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.HttpResponseSerializer;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.WebSocketMessageDTO;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class WebSocketMessageSerializer {
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private Map<Class, Serializer> serializers;

    public WebSocketMessageSerializer(MockServerLogger mockServerLogger) {
        this.serializers = ImmutableMap.of(HttpRequest.class, (Object)new HttpRequestSerializer(mockServerLogger), HttpResponse.class, (Object)new HttpResponseSerializer(mockServerLogger));
    }

    public String serialize(Object message) throws JsonProcessingException {
        if (this.serializers.containsKey(message.getClass())) {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.serializers.get(message.getClass()).serialize(message)));
        }
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.objectMapper.writeValueAsString(message)));
    }

    public Object deserialize(String messageJson) throws ClassNotFoundException, IOException {
        WebSocketMessageDTO webSocketMessageDTO = (WebSocketMessageDTO)this.objectMapper.readValue(messageJson, WebSocketMessageDTO.class);
        if (webSocketMessageDTO.getType() != null && webSocketMessageDTO.getValue() != null) {
            Class<?> format = Class.forName(webSocketMessageDTO.getType());
            if (this.serializers.containsKey(format)) {
                return this.serializers.get(format).deserialize(webSocketMessageDTO.getValue());
            }
            return this.objectMapper.readValue(webSocketMessageDTO.getValue(), format);
        }
        return null;
    }
}

