/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.client.netty.HttpClientConnectionHandler;
import org.mockserver.client.netty.HttpClientHandler;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.netty.codec.MockServerClientCodec;
import org.mockserver.client.netty.proxy.ProxyConfiguration;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.NettySslContextFactory;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final HttpClientConnectionHandler httpClientConnectionHandler = new HttpClientConnectionHandler();
    private final HttpClientHandler httpClientHandler;
    private final ProxyConfiguration proxyConfiguration;

    public HttpClientInitializer(ProxyConfiguration proxyConfiguration, MockServerLogger mockServerLogger) {
        this.proxyConfiguration = proxyConfiguration;
        this.mockServerLogger = mockServerLogger;
        this.httpClientHandler = new HttpClientHandler(mockServerLogger);
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.proxyConfiguration != null) {
            if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.HTTPS) {
                pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress())});
            } else if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.SOCKS5) {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress())});
            }
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientConnectionHandler});
        if (channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && ((Boolean)channel.attr(NettyHttpClient.SECURE).get()).booleanValue()) {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
            pipeline.addLast(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createClientSslContext().newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort())});
        }
        if (this.mockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("NettyHttpClient -->")});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerClientCodec()});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }
}

