/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.validator.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.file.FileReader;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator
extends ObjectWithReflectiveEqualsHashCodeToString
implements Validator<String> {
    private static Logger logger = LoggerFactory.getLogger(JsonSchemaValidator.class);
    private final String schema;
    private final JsonValidator validator = JsonSchemaFactory.byDefault().getValidator();
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public JsonSchemaValidator(String schema) {
        if (schema.trim().endsWith(".json")) {
            this.schema = FileReader.readFileFromClassPathOrPath(schema);
        } else if (schema.trim().endsWith("}")) {
            this.schema = schema;
        } else {
            throw new IllegalArgumentException("Schema must either be a path reference to a *.json file or a json string");
        }
    }

    protected static String addReferencesIntoSchema(String routePath, String mainSchemeFile, String ... referenceFiles) {
        String combinedSchema = "";
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
            JsonNode jsonSchema = objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + mainSchemeFile + ".json"));
            JsonNode definitions = jsonSchema.get("definitions");
            if (definitions != null && definitions instanceof ObjectNode) {
                for (String definitionName : referenceFiles) {
                    ((ObjectNode)definitions).set(definitionName, objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + definitionName + ".json")));
                }
            }
            combinedSchema = ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema);
        }
        catch (Exception e) {
            logger.error("Exception loading JSON Schema for Exceptions", (Throwable)e);
        }
        return combinedSchema;
    }

    @Override
    public String isValid(String json) {
        String validationResult = "";
        if (!Strings.isNullOrEmpty((String)json)) {
            try {
                ProcessingReport processingReport = this.validator.validate(this.objectMapper.readTree(this.schema), this.objectMapper.readTree(json), true);
                if (!processingReport.isSuccess()) {
                    validationResult = this.formatProcessingReport(processingReport);
                }
            }
            catch (Exception e) {
                logger.info("Exception validating JSON", (Throwable)e);
                return e.getClass().getSimpleName() + " - " + e.getMessage();
            }
        }
        return validationResult;
    }

    private String formatProcessingReport(ProcessingReport validate) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (ProcessingMessage processingMessage : validate) {
            String fieldPointer = "";
            if (processingMessage.asJson().get("instance") != null && processingMessage.asJson().get("instance").get("pointer") != null) {
                fieldPointer = String.valueOf(processingMessage.asJson().get("instance").get("pointer")).replaceAll("\"", "");
            }
            if (fieldPointer.endsWith("/headers")) {
                validationErrors.add("for field \"" + fieldPointer + "\" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : {" + Character.NEW_LINE + "        \"exampleHeaderName\" : [ \"exampleHeaderValue\" ]" + Character.NEW_LINE + "        \"exampleMultiValuedHeaderName\" : [ \"exampleHeaderValueOne\", \"exampleHeaderValueTwo\" ]" + Character.NEW_LINE + "    }" + Character.NEW_LINE + Character.NEW_LINE + "   or:" + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : [" + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleHeaderName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleHeaderValue\" ]" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleMultiValuedHeaderName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleHeaderValueOne\", \"exampleHeaderValueTwo\" ]" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    ]");
                continue;
            }
            if (fieldPointer.endsWith("/queryStringParameters")) {
                validationErrors.add("for field \"" + fieldPointer + "\" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : {" + Character.NEW_LINE + "        \"exampleParameterName\" : [ \"exampleParameterValue\" ]" + Character.NEW_LINE + "        \"exampleMultiValuedParameterName\" : [ \"exampleParameterValueOne\", \"exampleParameterValueTwo\" ]" + Character.NEW_LINE + "    }" + Character.NEW_LINE + Character.NEW_LINE + "   or:" + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : [" + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleParameterName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleParameterValue\" ]" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleMultiValuedParameterName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleParameterValueOne\", \"exampleParameterValueTwo\" ]" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    ]");
                continue;
            }
            if (fieldPointer.endsWith("/cookies")) {
                validationErrors.add("for field \"" + fieldPointer + "\" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : {" + Character.NEW_LINE + "        \"exampleCookieNameOne\" : \"exampleCookieValueOne\"" + Character.NEW_LINE + "        \"exampleCookieNameTwo\" : \"exampleCookieValueTwo\"" + Character.NEW_LINE + "    }" + Character.NEW_LINE + Character.NEW_LINE + "   or:" + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : [" + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleCookieNameOne\"," + Character.NEW_LINE + "            \"values\" : \"exampleCookieValueOne\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleCookieNameTwo\"," + Character.NEW_LINE + "            \"values\" : \"exampleCookieValueTwo\"" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    ]");
                continue;
            }
            if (fieldPointer.endsWith("/body")) {
                validationErrors.add("for field \"" + fieldPointer + "\" a plain string or one of the following example bodies must be specified " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"BINARY\"," + Character.NEW_LINE + "     \"base64Bytes\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }, " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON\"," + Character.NEW_LINE + "     \"json\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"," + Character.NEW_LINE + "     \"matchType\": \"ONLY_MATCHING_FIELDS\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON_SCHEMA\"," + Character.NEW_LINE + "     \"jsonSchema\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"PARAMETERS\"," + Character.NEW_LINE + "     \"parameters\": \"TO DO\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"REGEX\"," + Character.NEW_LINE + "     \"regex\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"STRING\"," + Character.NEW_LINE + "     \"string\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XML\"," + Character.NEW_LINE + "     \"xml\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XML_SCHEMA\"," + Character.NEW_LINE + "     \"xmlSchema\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XPATH\"," + Character.NEW_LINE + "     \"xpath\": \"\"" + Character.NEW_LINE + "   }");
                continue;
            }
            if (String.valueOf(processingMessage.asJson().get("keyword")).equals("\"oneOf\"")) {
                StringBuilder oneOfErrorMessage = new StringBuilder("oneOf of the following must be specified ");
                for (JsonNode jsonNode : processingMessage.asJson().get("reports")) {
                    if (jsonNode.get(0) == null || jsonNode.get(0).get("required") == null || jsonNode.get(0).get("required").get(0) == null) continue;
                    oneOfErrorMessage.append(String.valueOf(jsonNode.get(0).get("required").get(0))).append(" ");
                }
                validationErrors.add(oneOfErrorMessage.toString() + (fieldPointer.isEmpty() ? "" : " for field \"" + fieldPointer + "\""));
                continue;
            }
            validationErrors.add(processingMessage.getMessage() + (fieldPointer.isEmpty() ? "" : " for field \"" + fieldPointer + "\""));
        }
        return validationErrors.size() + " error" + (validationErrors.size() > 1 ? "s" : "") + ":" + Character.NEW_LINE + " - " + Joiner.on((String)(Character.NEW_LINE + " - ")).join(validationErrors);
    }
}

