/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.responsewriter;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public abstract class ResponseWriter {
    public abstract void writeResponse(HttpRequest var1, HttpResponseStatus var2);

    public abstract void writeResponse(HttpRequest var1, HttpResponseStatus var2, String var3, String var4);

    public abstract void writeResponse(HttpRequest var1, HttpResponse var2);

    protected void addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getKeepAliveOverride() != null) {
            if (connectionOptions.getKeepAliveOverride().booleanValue()) {
                response.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
            } else {
                response.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
            }
        } else if (connectionOptions == null || ConnectionOptions.isFalseOrNull(connectionOptions.getSuppressConnectionHeader())) {
            if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue() && (connectionOptions == null || ConnectionOptions.isFalseOrNull(connectionOptions.getCloseSocket()))) {
                response.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
            } else {
                response.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
            }
        }
    }
}

