/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.Not;

public class NottableString
extends Not {
    private final String value;

    private NottableString(String value, Boolean not) {
        this.value = value;
        this.not = not;
    }

    public static NottableString deserializeNottableString(String string) {
        if (string.startsWith("!")) {
            return NottableString.not(string.replaceFirst("^!", ""));
        }
        return NottableString.string(string.replaceFirst("^!", ""));
    }

    public static List<NottableString> deserializeNottableStrings(String ... strings) {
        return NottableString.deserializeNottableStrings(Arrays.asList(strings));
    }

    public static List<NottableString> deserializeNottableStrings(List<String> strings) {
        return Lists.transform(strings, (Function)new Function<String, NottableString>(){

            public NottableString apply(String input) {
                return NottableString.deserializeNottableString(input);
            }
        });
    }

    public static String serialiseNottableString(NottableString nottableString) {
        return (nottableString.isNot() ? "!" : "") + nottableString.value;
    }

    public static List<String> serialiseNottableString(List<NottableString> strings) {
        return Lists.transform(strings, (Function)new Function<NottableString, String>(){

            public String apply(NottableString input) {
                return NottableString.serialiseNottableString(input);
            }
        });
    }

    public static NottableString string(String value, Boolean not) {
        return new NottableString(value, not);
    }

    public static NottableString string(String value) {
        return new NottableString(value, false);
    }

    public static NottableString not(String value) {
        return new NottableString(value, Boolean.TRUE);
    }

    public static List<NottableString> strings(String ... values) {
        return NottableString.strings(Arrays.asList(values));
    }

    public static List<NottableString> strings(Collection<String> values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public String getValue() {
        return this.value;
    }

    public NottableString capitalize() {
        Object[] split = (this.value + "_").split("-");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.capitalize((String)split[i]);
        }
        return new NottableString(StringUtils.substringBeforeLast((String)Joiner.on((String)"-").join(split), (String)"_"), this.not);
    }

    public NottableString lowercase() {
        return new NottableString(this.value.toLowerCase(), this.not);
    }

    @Override
    public boolean equals(Object other) {
        return this.equals(other, false);
    }

    public boolean equalsIgnoreCase(Object other) {
        return this.equals(other, true);
    }

    private boolean equals(Object other, boolean ignoreCase) {
        if (other instanceof String) {
            if (ignoreCase) {
                return this.isNot() != ((String)other).equalsIgnoreCase(this.value);
            }
            return this.isNot() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            NottableString otherNottableString = (NottableString)other;
            if (otherNottableString.getValue() == null) {
                return this.value == null;
            }
            if (ignoreCase) {
                return otherNottableString.isNot() == (this.isNot() == otherNottableString.getValue().equalsIgnoreCase(this.value));
            }
            return otherNottableString.isNot() == (this.isNot() == otherNottableString.getValue().equals(this.value));
        }
        return false;
    }
}

