/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public class KeyToMultiValue
extends ObjectWithJsonToString {
    private final NottableString name;
    private final List<NottableString> values;

    public KeyToMultiValue(String name, String ... values) {
        this(NottableString.string(name), NottableString.strings(values));
    }

    public KeyToMultiValue(NottableString name, NottableString ... values) {
        this(name, Arrays.asList(values));
    }

    public KeyToMultiValue(String name, Collection<String> values) {
        this(NottableString.string(name), NottableString.strings(values));
    }

    public KeyToMultiValue(NottableString name, Collection<NottableString> values) {
        this.name = name;
        this.values = values == null || values.isEmpty() ? Collections.singletonList(NottableString.string(".*")) : new ArrayList<NottableString>(values);
    }

    public NottableString getName() {
        return this.name;
    }

    public List<NottableString> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        if (this.values != null && !this.values.contains(NottableString.string(value))) {
            this.values.add(NottableString.string(value));
        }
    }

    public void addValue(NottableString value) {
        if (this.values != null && !this.values.contains(value)) {
            this.values.add(value);
        }
    }

    public void addValues(List<String> values) {
        if (this.values != null) {
            for (String value : values) {
                if (this.values.contains(NottableString.string(value))) continue;
                this.values.add(NottableString.string(value));
            }
        }
    }

    public void addNottableValues(List<NottableString> values) {
        if (this.values != null) {
            for (NottableString value : values) {
                if (this.values.contains(value)) continue;
                this.values.add(value);
            }
        }
    }

    public void addValues(String ... values) {
        this.addValues(Arrays.asList(values));
    }

    public void addValues(NottableString ... values) {
        this.addNottableValues(Arrays.asList(values));
    }
}

