/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.Not;

public abstract class Body<T>
extends Not {
    private final Type type;

    public Body(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public abstract T getValue();

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.toString().getBytes(Charsets.UTF_8);
    }

    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        if (this instanceof BodyWithContentType) {
            return this.getCharset(defaultIfNotSet);
        }
        return defaultIfNotSet;
    }

    public String getContentType() {
        if (this instanceof BodyWithContentType) {
            return this.getContentType();
        }
        return null;
    }

    public static enum Type {
        BINARY,
        JSON,
        JSON_SCHEMA,
        PARAMETERS,
        REGEX,
        STRING,
        XML,
        XML_SCHEMA,
        XPATH;

    }
}

