/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.Arrays;
import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.KeysAndValues;

public class HashMapMatcher
extends NotMatcher<List<KeyAndValue>> {
    private final CaseInsensitiveRegexHashMap hashMap;

    public HashMapMatcher(CaseInsensitiveRegexHashMap hashMap) {
        this.hashMap = hashMap;
    }

    @Override
    public boolean matches(KeyAndValue ... values) {
        return this.matches(Arrays.asList(values));
    }

    @Override
    public boolean matches(List<KeyAndValue> values) {
        boolean result = false;
        if (this.hashMap == null) {
            result = true;
        } else if (KeysAndValues.toCaseInsensitiveRegexMultiMap(values).containsAll(this.hashMap)) {
            result = true;
        } else {
            this.logger.trace("Map [{}] is not a subset of {}", (Object)this.hashMap, values);
        }
        return this.reverseResultIfNot(result);
    }
}

