/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.unification;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import org.mockserver.socket.NettySslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EchoServerPortUnificationHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final AttributeKey<Boolean> SSL_ENABLED = AttributeKey.valueOf((String)"SSL_ENABLED");
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    EchoServerPortUnificationHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        if (msg.readableBytes() < 3) {
            return;
        }
        if (this.isSsl(msg)) {
            this.enableSsl(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.switchToHttp(ctx, msg);
        } else {
            msg.clear();
            ctx.close();
        }
        if (this.logger.isTraceEnabled()) {
            if (ctx.pipeline().get(org.mockserver.logging.LoggingHandler.class) != null) {
                ctx.pipeline().remove(org.mockserver.logging.LoggingHandler.class);
            }
            if (ctx.pipeline().get(SslHandler.class) != null) {
                ctx.pipeline().addAfter("SslHandler#0", "LoggingHandler#0", (ChannelHandler)new org.mockserver.logging.LoggingHandler(this.logger));
            } else {
                ctx.pipeline().addFirst(new ChannelHandler[]{new org.mockserver.logging.LoggingHandler(this.logger)});
            }
        }
    }

    private boolean isSsl(ByteBuf buf) {
        return buf.readableBytes() >= 5 && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private boolean isHttp(ByteBuf msg) {
        short letterOne = msg.getUnsignedByte(msg.readerIndex());
        short letterTwo = msg.getUnsignedByte(msg.readerIndex() + 1);
        short letterThree = msg.getUnsignedByte(msg.readerIndex() + 2);
        return letterOne == 71 && letterTwo == 69 && letterThree == 84 || letterOne == 80 && letterTwo == 79 && letterThree == 83 || letterOne == 80 && letterTwo == 85 && letterThree == 84 || letterOne == 72 && letterTwo == 69 && letterThree == 65 || letterOne == 79 && letterTwo == 80 && letterThree == 84 || letterOne == 80 && letterTwo == 65 && letterThree == 84 || letterOne == 68 && letterTwo == 69 && letterThree == 76 || letterOne == 84 && letterTwo == 82 && letterThree == 65 || letterOne == 67 && letterTwo == 79 && letterThree == 78;
    }

    private void enableSsl(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(ctx.alloc())});
        ctx.channel().attr(SSL_ENABLED).set((Object)Boolean.TRUE);
        ctx.pipeline().fireChannelRead((Object)msg);
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpServerCodec(8192, 8192, 8192));
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentDecompressor());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
        if (this.logger.isDebugEnabled()) {
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new LoggingHandler());
        }
        this.configurePipeline(pipeline);
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)msg);
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(new ChannelHandler[]{channelHandler});
        }
    }

    private void configurePipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpRequest>(){

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
                HttpResponseStatus responseStatus = HttpResponseStatus.OK;
                if (request.uri().equals("/not_found")) {
                    responseStatus = HttpResponseStatus.NOT_FOUND;
                }
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((ByteBuf)request.content()));
                response.headers().add(request.headers());
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                if (HttpUtil.isKeepAlive((HttpMessage)request)) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                }
                if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                    ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                ctx.writeAndFlush((Object)response);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                cause.printStackTrace();
                ctx.close();
            }
        }});
    }
}

