/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.mockserver.echo.http.EchoServerInitializer;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServer {
    static final AttributeKey<LogFilter> LOG_FILTER = AttributeKey.valueOf((String)"SERVER_LOG_FILTER");
    static final AttributeKey<NextResponse> NEXT_RESPONSE = AttributeKey.valueOf((String)"NEXT_RESPONSE");
    static final AttributeKey<OnlyResponse> ONLY_RESPONSE = AttributeKey.valueOf((String)"ONLY_RESPONSE");
    private final LogFilter logFilter = new LogFilter(new LoggingFormatter(LoggerFactory.getLogger(this.getClass()), null));
    private final NextResponse nextResponse = new NextResponse();
    private final OnlyResponse onlyResponse = new OnlyResponse();
    private final NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();

    public EchoServer(int port, boolean secure) {
        this(port, secure, null);
    }

    public EchoServer(final int port, final boolean secure, final Error error) {
        Logger logger = LoggerFactory.getLogger(EchoServer.class);
        final SettableFuture hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            @Override
            public void run() {
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler("EchoServer Handler"))).childHandler((ChannelHandler)new EchoServerInitializer(secure, error)).childAttr(LOG_FILTER, (Object)EchoServer.this.logFilter).childAttr(NEXT_RESPONSE, (Object)EchoServer.this.nextResponse).childAttr(ONLY_RESPONSE, (Object)EchoServer.this.onlyResponse).bind(port).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            hasStarted.set((Object)"STARTED");
                        } else {
                            hasStarted.setException(future.cause());
                            EchoServer.this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        }, "MockServer EchoServer Thread").start();
        try {
            hasStarted.get();
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            logger.error("Exception while waiting for proxy to complete starting up", (Throwable)e);
        }
    }

    public void stop() {
        this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
    }

    public LogFilter requestLogFilter() {
        return this.logFilter;
    }

    public EchoServer withNextResponse(HttpResponse ... httpResponses) {
        this.nextResponse.httpResponse.addAll(Arrays.asList(httpResponses));
        return this;
    }

    public EchoServer withOnlyResponse(HttpResponse httpResponse) {
        this.onlyResponse.httpResponse = httpResponse;
        return this;
    }

    public class OnlyResponse {
        public HttpResponse httpResponse;
    }

    public class NextResponse {
        public final Queue<HttpResponse> httpResponse = new LinkedList<HttpResponse>();
    }

    public static enum Error {
        CLOSE_CONNECTION,
        LARGER_CONTENT_LENGTH,
        SMALLER_CONTENT_LENGTH,
        RANDOM_BYTES_RESPONSE;

    }
}

