/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.deserializers.string;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.NottableString;

public class NottableStringDeserializer
extends JsonDeserializer<NottableString> {
    public NottableString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            Boolean not = null;
            String string = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jsonParser.getCurrentName();
                if ("not".equals(fieldName)) {
                    jsonParser.nextToken();
                    not = jsonParser.getBooleanValue();
                    continue;
                }
                if (!"value".equals(fieldName)) continue;
                jsonParser.nextToken();
                string = (String)ctxt.readValue(jsonParser, String.class);
            }
            if (StringUtils.isEmpty(string)) {
                return null;
            }
            return NottableString.string(string, not);
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING || jsonParser.getCurrentToken() == JsonToken.FIELD_NAME) {
            return NottableString.deserializeNottableString((String)ctxt.readValue(jsonParser, String.class));
        }
        return null;
    }
}

