/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.deserializers.collections;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import org.mockserver.model.KeysToMultiValues;
import org.mockserver.model.NottableString;

public abstract class KeysToMultiValuesDeserializer<T extends KeysToMultiValues>
extends StdDeserializer<T> {
    KeysToMultiValuesDeserializer(Class<T> valueClass) {
        super(valueClass);
    }

    public abstract T build();

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            return this.deserializeArray(p, ctxt, ctxt.getNodeFactory());
        }
        if (p.isExpectedStartObjectToken()) {
            return this.deserializeObject(p, ctxt, ctxt.getNodeFactory());
        }
        return null;
    }

    private T deserializeObject(JsonParser jsonParser, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonToken token;
        T enteries = this.build();
        NottableString key = NottableString.string("");
        block5: while (true) {
            token = jsonParser.nextToken();
            switch (token) {
                case FIELD_NAME: {
                    key = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    continue block5;
                }
                case START_ARRAY: {
                    ((KeysToMultiValues)enteries).withEntry(key, (NottableString[])ctxt.readValue(jsonParser, NottableString[].class));
                    continue block5;
                }
                case END_OBJECT: {
                    return enteries;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + token + "\" id: \"" + token.id() + "\" text: \"" + jsonParser.getText());
    }

    private T deserializeArray(JsonParser jsonParser, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonToken token;
        T entries = this.build();
        NottableString key = NottableString.string("");
        NottableString[] values = null;
        block8: while (true) {
            token = jsonParser.nextToken();
            switch (token) {
                case START_ARRAY: {
                    values = (NottableString[])ctxt.readValue(jsonParser, NottableString[].class);
                    continue block8;
                }
                case END_ARRAY: {
                    return entries;
                }
                case START_OBJECT: {
                    key = key != null ? null : (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    values = null;
                    continue block8;
                }
                case END_OBJECT: {
                    ((KeysToMultiValues)entries).withEntry(key, values);
                    continue block8;
                }
                case FIELD_NAME: {
                    continue block8;
                }
                case VALUE_STRING: {
                    key = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    continue block8;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + token + "\" id: \"" + token.id() + "\" text: \"" + jsonParser.getText());
    }
}

