/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.VerificationDTO;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationValidator;
import org.mockserver.verify.Verification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationSerializer
implements Serializer<Verification> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonSchemaVerificationValidator verificationValidator = new JsonSchemaVerificationValidator();

    @Override
    public String serialize(Verification verification) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VerificationDTO(verification));
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing verification to JSON with value " + verification, (Throwable)e);
            throw new RuntimeException("Exception while serializing verification to JSON with value " + verification, e);
        }
    }

    @Override
    public Verification deserialize(String jsonVerification) {
        if (Strings.isNullOrEmpty((String)jsonVerification)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification is required but value was \"" + String.valueOf(jsonVerification) + "\"");
        }
        String validationErrors = this.verificationValidator.isValid(jsonVerification);
        if (validationErrors.isEmpty()) {
            Verification verification = null;
            try {
                VerificationDTO verificationDTO = (VerificationDTO)this.objectMapper.readValue(jsonVerification, VerificationDTO.class);
                if (verificationDTO != null) {
                    verification = verificationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.logger.info("Exception while parsing [" + jsonVerification + "] for Verification", (Throwable)e);
                throw new RuntimeException("Exception while parsing [" + jsonVerification + "] for Verification", e);
            }
            return verification;
        }
        this.logger.info("Validation failed:" + Character.NEW_LINE + validationErrors + Character.NEW_LINE + "-- Expectation:" + Character.NEW_LINE + jsonVerification + Character.NEW_LINE + "-- Schema:" + Character.NEW_LINE + this.verificationValidator.getSchema());
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<Verification> supportsType() {
        return Verification.class;
    }
}

