/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.websocket;

import com.google.common.base.Strings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.mockserver.client.netty.codec.mappers.FullHttpResponseToMockServerResponse;
import org.mockserver.client.netty.websocket.WebSocketClient;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.mappers.ContentTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientHandshaker handshaker;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public WebSocketClientHandler(InetSocketAddress serverAddress, String contextPath, WebSocketClient webSocketClient) throws URISyntaxException {
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI("ws://" + serverAddress.getHostName() + ":" + serverAddress.getPort() + this.cleanContextPath(contextPath) + "/_mockserver_callback_websocket"), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders(), (int)Integer.MAX_VALUE);
        this.webSocketClient = webSocketClient;
    }

    private String cleanContextPath(String contextPath) {
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            return (!contextPath.startsWith("/") ? "/" : "") + contextPath;
        }
        return "";
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.logger.debug("web socket client disconnected");
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            if (httpResponse.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true) && !this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, httpResponse);
                this.webSocketClient.registrationFuture().set((Object)httpResponse.headers().get("X-CLIENT-REGISTRATION-ID"));
                this.logger.debug("web socket client " + (String)this.webSocketClient.registrationFuture().get() + " connected!");
                return;
            }
            if (httpResponse.status().equals((Object)HttpResponseStatus.NOT_ACCEPTABLE)) {
                throw new WebSocketException(this.readRequestBody(httpResponse));
            }
            throw new WebSocketException("Unsupported web socket message " + new FullHttpResponseToMockServerResponse().mapMockServerResponseToFullHttpResponse(httpResponse));
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            this.webSocketClient.receivedTextWebSocketFrame((TextWebSocketFrame)frame);
        } else if (frame instanceof CloseWebSocketFrame) {
            this.logger.debug("web socket client received request to close");
            ch.close();
        }
    }

    private String readRequestBody(FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            Charset requestCharset = ContentTypeMapper.getCharsetFromContentTypeHeader(fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
            return new String(bodyBytes, requestCharset);
        }
        return "";
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("web socket client caught exception", cause);
        if (!this.webSocketClient.registrationFuture().isDone()) {
            this.webSocketClient.registrationFuture().setException(cause);
        }
        ctx.close();
    }
}

