/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action.http;

import org.mockserver.configuration.Configuration;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.mustache.MustacheTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class HttpResponseTemplateActionHandler {
    private final MockServerLogger mockServerLogger;
    private final Configuration configuration;
    private VelocityTemplateEngine velocityTemplateEngine;
    private JavaScriptTemplateEngine javascriptTemplateEngine;
    private MustacheTemplateEngine mustacheTemplateEngine;

    public HttpResponseTemplateActionHandler(MockServerLogger mockServerLogger, Configuration configuration) {
        this.mockServerLogger = mockServerLogger;
        this.configuration = configuration;
    }

    public HttpResponse handle(HttpTemplate httpTemplate, HttpRequest httpRequest) {
        HttpResponse templatedResponse;
        TemplateEngine templateEngine;
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.getVelocityTemplateEngine();
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.getJavaScriptTemplateEngine();
                break;
            }
            case MUSTACHE: {
                templateEngine = this.getMustacheTemplateEngine();
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedResponse = (HttpResponse)templateEngine.executeTemplate(httpTemplate.getTemplate(), httpRequest, HttpResponseDTO.class)) != null) {
            return templatedResponse;
        }
        return httpResponse;
    }

    private VelocityTemplateEngine getVelocityTemplateEngine() {
        if (this.velocityTemplateEngine == null) {
            this.velocityTemplateEngine = new VelocityTemplateEngine(this.mockServerLogger, this.configuration);
        }
        return this.velocityTemplateEngine;
    }

    private JavaScriptTemplateEngine getJavaScriptTemplateEngine() {
        if (this.javascriptTemplateEngine == null) {
            this.javascriptTemplateEngine = new JavaScriptTemplateEngine(this.mockServerLogger, this.configuration);
        }
        return this.javascriptTemplateEngine;
    }

    private MustacheTemplateEngine getMustacheTemplateEngine() {
        if (this.mustacheTemplateEngine == null) {
            this.mustacheTemplateEngine = new MustacheTemplateEngine(this.mockServerLogger, this.configuration);
        }
        return this.mustacheTemplateEngine;
    }
}

