/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.initialize;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.cache.LRUCache;
import org.mockserver.configuration.Configuration;
import org.mockserver.file.FilePath;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializer;
import org.slf4j.event.Level;

public class ExpectationInitializerLoader {
    private static final LRUCache<String, List<String>> EXPANDED_INITIALIZATION_JSON_PATHS = new LRUCache(new MockServerLogger(LRUCache.class), 10, TimeUnit.HOURS.toMillis(1L));
    private final Configuration configuration;
    private final ExpectationSerializer expectationSerializer;
    private final MockServerLogger mockServerLogger;
    private final RequestMatchers requestMatchers;

    public ExpectationInitializerLoader(Configuration configuration, MockServerLogger mockServerLogger, RequestMatchers requestMatchers) {
        this.configuration = configuration;
        this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.requestMatchers = requestMatchers;
        this.addExpectationsFromInitializer();
    }

    public static List<String> expandedInitializationJsonPaths(String initializationJsonPath) {
        if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
            List<String> expandedInitializationJsonPaths = EXPANDED_INITIALIZATION_JSON_PATHS.get(initializationJsonPath);
            if (expandedInitializationJsonPaths == null) {
                expandedInitializationJsonPaths = FilePath.expandFilePathGlobs(initializationJsonPath);
                EXPANDED_INITIALIZATION_JSON_PATHS.put(initializationJsonPath, expandedInitializationJsonPaths);
            }
            return expandedInitializationJsonPaths;
        }
        return Collections.emptyList();
    }

    private void addExpectationsFromInitializer() {
        this.retrieveExpectationsFromJson();
        for (Expectation expectation : this.retrieveExpectationsFromInitializerClass()) {
            this.requestMatchers.add(expectation, new MockServerMatcherNotifier.Cause("", MockServerMatcherNotifier.Cause.Type.CLASS_INITIALISER));
        }
    }

    private Expectation[] retrieveExpectationsFromInitializerClass() {
        Expectation[] expectations;
        block7: {
            expectations = new Expectation[]{};
            String initializationClass = this.configuration.initializationClass();
            try {
                if (StringUtils.isNotBlank((CharSequence)initializationClass)) {
                    Constructor<?> initializerClassConstructor;
                    Object expectationInitializer;
                    ClassLoader contextClassLoader;
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat("loading class initialization file:{}").setArguments(initializationClass));
                    }
                    if ((contextClassLoader = ExpectationInitializerLoader.class.getClassLoader()) != null && StringUtils.isNotBlank((CharSequence)initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                        expectations = ((ExpectationInitializer)expectationInitializer).initializeExpectations();
                    }
                }
                if (expectations.length > 0) {
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded expectations:{}from class:{}").setArguments(Arrays.asList(expectations), initializationClass));
                    }
                    this.requestMatchers.update(expectations, new MockServerMatcherNotifier.Cause(initializationClass, MockServerMatcherNotifier.Cause.Type.CLASS_INITIALISER));
                }
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled(Level.WARN)) break block7;
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("exception while loading JSON initialization class, ignoring class:{}").setArguments(initializationClass).setThrowable(throwable));
            }
        }
        return expectations;
    }

    private Expectation[] retrieveExpectationsFromJson() {
        return this.retrieveExpectationsFromFile("loading JSON initialization file:{}", "exception while loading JSON initialization file, ignoring file:{}", "loaded expectations:{}from file:{}", MockServerMatcherNotifier.Cause.Type.FILE_INITIALISER).toArray(new Expectation[0]);
    }

    public List<Expectation> retrieveExpectationsFromFile(String initialLogMessage, String expectationLogMessage, String completedLogMessage, MockServerMatcherNotifier.Cause.Type causeType) {
        List<String> initializationJsonPaths = ExpectationInitializerLoader.expandedInitializationJsonPaths(this.configuration.initializationJsonPath());
        return initializationJsonPaths.stream().flatMap(initializationJsonPath -> {
            Expectation[] expectations;
            block6: {
                expectations = new Expectation[]{};
                if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
                    if (StringUtils.isNotBlank((CharSequence)initialLogMessage) && MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat(initialLogMessage).setArguments(initializationJsonPath));
                    }
                    ArrayList expectationIds = new ArrayList();
                    try {
                        String jsonExpectations = FileReader.readFileFromClassPathOrPath(initializationJsonPath);
                        if (StringUtils.isNotBlank((CharSequence)jsonExpectations)) {
                            expectations = this.expectationSerializer.deserializeArray(jsonExpectations, true, (expectationString, deserialisedExpectations) -> {
                                for (int i = 0; i < deserialisedExpectations.size(); ++i) {
                                    String expectationId;
                                    int counter = 0;
                                    while (expectationIds.contains(expectationId = UUID.nameUUIDFromBytes(String.valueOf(Objects.hash(initializationJsonPath, expectationString, i, counter++)).getBytes(StandardCharsets.UTF_8)).toString()) && counter < 50) {
                                    }
                                    expectationIds.add(expectationId);
                                    ((Expectation)deserialisedExpectations.get(i)).withIdIfNull(expectationId);
                                }
                                return deserialisedExpectations;
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        if (!MockServerLogger.isEnabled(Level.WARN)) break block6;
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat(expectationLogMessage).setArguments(initializationJsonPath).setThrowable(throwable));
                    }
                }
            }
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat(completedLogMessage).setArguments(Arrays.asList(expectations), initializationJsonPath));
            }
            this.requestMatchers.update(expectations, new MockServerMatcherNotifier.Cause((String)initializationJsonPath, causeType));
            return Arrays.stream(expectations);
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    public Expectation[] loadExpectations() {
        Object[] expectationsFromInitializerClass = this.retrieveExpectationsFromInitializerClass();
        Object[] expectationsFromJson = this.retrieveExpectationsFromJson();
        return (Expectation[])ArrayUtils.addAll((Object[])expectationsFromInitializerClass, (Object[])expectationsFromJson);
    }
}

