/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Objects;
import org.mockserver.model.ObjectWithJsonToString;

public class X509Certificate
extends ObjectWithJsonToString {
    private Certificate certificate;
    private byte[] certificateBytes;
    private String issuerDistinguishedName;
    private String subjectDistinguishedName;
    private String serialNumber;
    private String signatureAlgorithmName;
    private int hashCode;

    public static X509Certificate x509Certificate() {
        return new X509Certificate();
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public X509Certificate withCertificate(Certificate certificate) {
        try {
            this.certificate = certificate;
            this.certificateBytes = certificate.getEncoded();
        }
        catch (CertificateEncodingException cee) {
            throw new RuntimeException(cee.getMessage(), cee);
        }
        this.hashCode = 0;
        return this;
    }

    public String getIssuerDistinguishedName() {
        return this.issuerDistinguishedName;
    }

    public X509Certificate withIssuerDistinguishedName(String issuerDistinguishedName) {
        this.issuerDistinguishedName = issuerDistinguishedName;
        this.hashCode = 0;
        return this;
    }

    public String getSubjectDistinguishedName() {
        return this.subjectDistinguishedName;
    }

    public X509Certificate withSubjectDistinguishedName(String subjectDistinguishedName) {
        this.subjectDistinguishedName = subjectDistinguishedName;
        this.hashCode = 0;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public X509Certificate withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        this.hashCode = 0;
        return this;
    }

    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    public X509Certificate withSignatureAlgorithmName(String signatureAlgorithmName) {
        this.signatureAlgorithmName = signatureAlgorithmName;
        this.hashCode = 0;
        return this;
    }

    public X509Certificate clone() {
        return X509Certificate.x509Certificate().withCertificate(this.certificate).withIssuerDistinguishedName(this.issuerDistinguishedName).withSubjectDistinguishedName(this.subjectDistinguishedName).withSerialNumber(this.serialNumber).withSignatureAlgorithmName(this.signatureAlgorithmName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        X509Certificate that = (X509Certificate)o;
        return Arrays.equals(this.certificateBytes, that.certificateBytes) && Objects.equals(this.issuerDistinguishedName, that.issuerDistinguishedName) && Objects.equals(this.subjectDistinguishedName, that.subjectDistinguishedName) && Objects.equals(this.serialNumber, that.serialNumber) && Objects.equals(this.signatureAlgorithmName, that.signatureAlgorithmName);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(Arrays.hashCode(this.certificateBytes), this.issuerDistinguishedName, this.subjectDistinguishedName, this.serialNumber, this.signatureAlgorithmName, this.hashCode);
        }
        return this.hashCode;
    }
}

