/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.scheduler.Scheduler;
import org.slf4j.event.Level;

public class FileWatcher {
    private static ScheduledExecutorService scheduler;
    private boolean running = true;
    private final ScheduledFuture<?> scheduledFuture;
    private static long pollPeriod;
    private static TimeUnit pollPeriodUnits;

    public static synchronized ScheduledExecutorService getScheduler() {
        if (scheduler == null) {
            scheduler = new ScheduledThreadPoolExecutor(2, new Scheduler.SchedulerThreadFactory("FileWatcher"), new ThreadPoolExecutor.CallerRunsPolicy());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> scheduler.shutdown()));
        }
        return scheduler;
    }

    public FileWatcher(Path filePath, Runnable updatedHandler, Consumer<Throwable> errorHandler, MockServerLogger mockServerLogger) {
        Path path = filePath.getParent() != null ? filePath : Paths.get(new File(".").getAbsolutePath(), filePath.toString());
        AtomicReference<Integer> fileHash = new AtomicReference<Integer>(this.getFileHash(path));
        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("watching file:{}with file fingerprint:{}").setArguments(path, fileHash));
        this.scheduledFuture = FileWatcher.getScheduler().scheduleAtFixedRate(() -> {
            try {
                if (!this.getFileHash(path).equals(fileHash.get())) {
                    updatedHandler.run();
                    fileHash.set(this.getFileHash(path));
                }
            }
            catch (Throwable throwable) {
                errorHandler.accept(throwable);
            }
        }, pollPeriod, pollPeriod, pollPeriodUnits);
    }

    private Integer getFileHash(Path path) {
        try {
            return Arrays.hashCode(Files.readAllBytes(path));
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public FileWatcher setRunning(boolean running) {
        this.running = running;
        if (!running && this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        return this;
    }

    public static long getPollPeriod() {
        return pollPeriod;
    }

    public static void setPollPeriod(long pollPeriod) {
        FileWatcher.pollPeriod = pollPeriod;
    }

    public static TimeUnit getPollPeriodUnits() {
        return pollPeriodUnits;
    }

    public static void setPollPeriodUnits(TimeUnit pollPeriodUnits) {
        FileWatcher.pollPeriodUnits = pollPeriodUnits;
    }

    static {
        pollPeriod = 5L;
        pollPeriodUnits = TimeUnit.SECONDS;
    }
}

