/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.responsewriter;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.version.Version;
import org.slf4j.event.Level;

public abstract class ResponseWriter {
    protected final Configuration configuration;
    protected final MockServerLogger mockServerLogger;
    private final CORSHeaders corsHeaders;

    protected ResponseWriter(Configuration configuration, MockServerLogger mockServerLogger) {
        this.configuration = configuration;
        this.mockServerLogger = mockServerLogger;
        this.corsHeaders = new CORSHeaders(configuration);
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(responseStatus.code()).withReasonPhrase(responseStatus.reasonPhrase()).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; charset=utf-8"));
        }
        this.writeResponse(request, response, true);
    }

    public void writeResponse(HttpRequest request, HttpResponse response, boolean apiResponse) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (this.configuration.enableCORSForAllResponses().booleanValue()) {
            this.corsHeaders.addCORSHeaders(request, response);
        } else if (apiResponse && this.configuration.enableCORSForAPI().booleanValue()) {
            this.corsHeaders.addCORSHeaders(request, response);
        }
        String contentLengthHeader = response.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (StringUtils.isNotBlank((CharSequence)contentLengthHeader)) {
            try {
                int contentLength = Integer.parseInt(contentLengthHeader);
                if (response.getBodyAsRawBytes().length > contentLength) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.INFO).setLogLevel(Level.INFO).setCorrelationId(request.getLogCorrelationId()).setHttpRequest(request).setHttpResponse(response).setMessageFormat("returning response with content-length header " + contentLength + " which is smaller then response body length " + response.getBodyAsRawBytes().length + ", body will likely be truncated by client receiving request"));
                }
            }
            catch (NumberFormatException contentLength) {
                // empty catch block
            }
        }
        if (apiResponse) {
            response.withHeader("version", Version.getVersion());
            String path = request.getPath().getValue();
            if (!path.startsWith("/mockserver") && !path.equals(this.configuration.livenessHttpGetPath())) {
                response.withHeader("deprecated", "\"" + path + "\" is deprecated use \"" + "/mockserver" + path + "\" instead");
            }
        }
        this.sendResponse(request, this.addConnectionHeader(request, response));
    }

    public abstract void sendResponse(HttpRequest var1, HttpResponse var2);

    protected HttpResponse addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        HttpResponse responseWithConnectionHeader = response.clone();
        if (connectionOptions != null && (connectionOptions.getSuppressConnectionHeader() != null || connectionOptions.getKeepAliveOverride() != null)) {
            if (!Boolean.TRUE.equals(connectionOptions.getSuppressConnectionHeader())) {
                if (Boolean.TRUE.equals(connectionOptions.getKeepAliveOverride())) {
                    responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
                } else {
                    responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
                }
            }
        } else if (Boolean.TRUE.equals(request.isKeepAlive())) {
            responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
        } else {
            responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
        }
        return responseWithConnectionHeader;
    }
}

