/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.AbstractHttpRequestMatcher;
import org.mockserver.matchers.HttpRequestPropertiesMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.KeyMatchStyle;
import org.mockserver.model.NottableOptionalString;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.ParameterStyle;
import org.mockserver.model.RequestDefinition;
import org.mockserver.openapi.OpenAPIParser;
import org.mockserver.openapi.OpenAPISerialiser;
import org.mockserver.openapi.examples.JsonNodeExampleSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class HttpRequestsPropertiesMatcher
extends AbstractHttpRequestMatcher {
    private static final ObjectWriter TO_STRING_OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private int hashCode;
    private OpenAPIDefinition openAPIDefinition;
    private List<HttpRequestPropertiesMatcher> httpRequestPropertiesMatchers;
    private List<HttpRequest> httpRequests;
    private static final ObjectWriter OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(new JsonNodeExampleSerializer()).writerWithDefaultPrettyPrinter();

    protected HttpRequestsPropertiesMatcher(Configuration configuration, MockServerLogger mockServerLogger) {
        super(configuration, mockServerLogger);
    }

    public List<HttpRequestPropertiesMatcher> getHttpRequestPropertiesMatchers() {
        return this.httpRequestPropertiesMatchers;
    }

    @Override
    public List<HttpRequest> getHttpRequests() {
        return this.httpRequests;
    }

    @Override
    public boolean apply(RequestDefinition requestDefinition) {
        return this.apply(requestDefinition, new ArrayList<LogEntry>());
    }

    @VisibleForTesting
    public boolean apply(RequestDefinition requestDefinition, List<LogEntry> logEntries) {
        OpenAPIDefinition openAPIDefinition;
        OpenAPIDefinition openAPIDefinition2 = openAPIDefinition = requestDefinition instanceof OpenAPIDefinition ? (OpenAPIDefinition)requestDefinition : null;
        if (this.openAPIDefinition == null || !this.openAPIDefinition.equals(openAPIDefinition)) {
            this.openAPIDefinition = openAPIDefinition;
            if (openAPIDefinition != null && StringUtils.isNotBlank((CharSequence)openAPIDefinition.getSpecUrlOrPayload())) {
                this.httpRequestPropertiesMatchers = new ArrayList<HttpRequestPropertiesMatcher>();
                this.httpRequests = new ArrayList<HttpRequest>();
                OpenAPISerialiser openAPISerialiser = new OpenAPISerialiser(this.mockServerLogger);
                try {
                    OpenAPI openAPI = OpenAPIParser.buildOpenAPI(openAPIDefinition.getSpecUrlOrPayload(), this.mockServerLogger);
                    try {
                        Map<String, List<Pair<String, Operation>>> stringListMap = openAPISerialiser.retrieveOperations(openAPI, openAPIDefinition.getOperationId());
                        stringListMap.forEach((path, operations) -> operations.forEach(methodOperationPair -> {
                            Operation operation = (Operation)methodOperationPair.getValue();
                            if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                                operation.getRequestBody().getContent().forEach(this.handleRequestBody(openAPIDefinition, openAPI, (String)path, (Pair<String, Operation>)methodOperationPair, Boolean.TRUE.equals(operation.getRequestBody().getRequired()), logEntries));
                            } else {
                                HttpRequest httpRequest = this.createHttpRequest(openAPIDefinition, openAPI, (String)path, (Pair<String, Operation>)methodOperationPair);
                                try {
                                    this.addRequestMatcher(openAPIDefinition, (Pair<String, Operation>)methodOperationPair, httpRequest, "");
                                }
                                catch (Throwable throwable) {
                                    logEntries.add(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while creating adding request matcher for operation:{}method:{}in open api:{}").setArguments(((Operation)methodOperationPair.getRight()).getOperationId(), methodOperationPair.getLeft(), openAPIDefinition));
                                }
                            }
                        }));
                    }
                    catch (Throwable throwable) {
                        logEntries.add(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat((StringUtils.isBlank((CharSequence)throwable.getMessage()) || !throwable.getMessage().contains("Unable to load API spec") ? "Unable to load API spec" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? ", " : "") : "") + throwable.getMessage() + " for open api:{}").setArguments(openAPIDefinition));
                    }
                }
                catch (Throwable throwable) {
                    String message = (StringUtils.isBlank((CharSequence)throwable.getMessage()) || !throwable.getMessage().contains("Unable to load API spec") ? "Unable to load API spec" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? ", " : "") : "") + throwable.getMessage();
                    throw new IllegalArgumentException(message, throwable);
                }
                logEntries.forEach(this.mockServerLogger::logEvent);
            }
            this.hashCode = 0;
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(requestDefinition).setMessageFormat("created request matcher{}for open api definition{}").setArguments(this, requestDefinition));
            }
            return true;
        }
        return false;
    }

    private HttpRequest createHttpRequest(OpenAPIDefinition openAPIDefinition, OpenAPI openAPI, String path, Pair<String, Operation> methodOperationPair) {
        HttpRequest httpRequest = new HttpRequest().withMethod((String)methodOperationPair.getKey()).withPath(path);
        Operation operation = (Operation)methodOperationPair.getValue();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                Schema schema = Optional.ofNullable(parameter.getSchema()).orElse(Optional.ofNullable(parameter.getContent()).flatMap(content -> content.values().stream().map(MediaType::getSchema).findFirst()).orElse(null));
                if (schema == null) continue;
                try {
                    NottableString name = (parameter.getRequired() != null && parameter.getRequired() != false ? NottableString.string(parameter.getName()) : NottableOptionalString.optional(parameter.getName())).withStyle(this.parameterStyle(parameter.getExplode(), parameter.getStyle()));
                    if (parameter.getAllowEmptyValue() != null && parameter.getAllowEmptyValue().booleanValue()) {
                        schema.nullable(Boolean.valueOf(true));
                    }
                    if (Boolean.TRUE.equals(parameter.getAllowReserved())) {
                        throw new IllegalArgumentException("allowReserved field is not supported on parameters, found on operation: \"" + ((Operation)methodOperationPair.getRight()).getOperationId() + "\" method: \"" + (String)methodOperationPair.getLeft() + "\" parameter: \"" + name + "\" in: \"" + parameter.getIn() + "\"");
                    }
                    switch (parameter.getIn()) {
                        case "path": {
                            httpRequest.withPathParameter(name, NottableSchemaString.schemaString(OBJECT_WRITER.writeValueAsString((Object)schema)));
                            break;
                        }
                        case "query": {
                            httpRequest.withQueryStringParameter(name, NottableSchemaString.schemaString(OBJECT_WRITER.writeValueAsString((Object)schema)));
                            break;
                        }
                        case "header": {
                            httpRequest.withHeader(name, NottableSchemaString.schemaString(OBJECT_WRITER.writeValueAsString((Object)schema)));
                            break;
                        }
                        case "cookie": {
                            httpRequest.withCookie(name, NottableSchemaString.schemaString(OBJECT_WRITER.writeValueAsString((Object)schema)));
                            break;
                        }
                        default: {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("unknown value for the parameter in property, expected \"query\", \"header\", \"path\" or \"cookie\" found \"" + parameter.getIn() + "\""));
                            break;
                        }
                    }
                }
                catch (IOException exception) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while creating adding parameter{}from the schema{}").setArguments(parameter, openAPIDefinition).setThrowable(exception));
                }
            }
            if (httpRequest.getPathParameters() != null) {
                httpRequest.getPathParameters().withKeyMatchStyle(KeyMatchStyle.MATCHING_KEY);
            }
            if (httpRequest.getQueryStringParameters() != null) {
                httpRequest.getQueryStringParameters().withKeyMatchStyle(KeyMatchStyle.MATCHING_KEY);
            }
            if (httpRequest.getHeaders() != null) {
                httpRequest.getHeaders().withKeyMatchStyle(KeyMatchStyle.MATCHING_KEY);
            }
        }
        HashMap<String, Set<String>> headerRequirements = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> queryStringParameterRequirements = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> cookieRequirements = new HashMap<String, Set<String>>();
        this.buildSecurityValues(openAPI, headerRequirements, queryStringParameterRequirements, cookieRequirements, openAPI.getSecurity());
        this.buildSecurityValues(openAPI, headerRequirements, queryStringParameterRequirements, cookieRequirements, ((Operation)methodOperationPair.getRight()).getSecurity());
        if (!headerRequirements.isEmpty()) {
            if (headerRequirements.keySet().size() > 1) {
                for (Map.Entry headerMatchEntry : headerRequirements.entrySet()) {
                    httpRequest.withHeader("?" + (String)headerMatchEntry.getKey(), Joiner.on((String)"|").join((Iterable)headerMatchEntry.getValue()));
                }
                httpRequest.withHeader(Joiner.on((String)"|").join(headerRequirements.keySet()), ".*");
            } else if (!queryStringParameterRequirements.isEmpty() || !cookieRequirements.isEmpty()) {
                httpRequest.withHeader("?" + Joiner.on((String)"|").join(headerRequirements.keySet()), Joiner.on((String)"|").join((Iterable)headerRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            } else {
                httpRequest.withHeader(Joiner.on((String)"|").join(headerRequirements.keySet()), Joiner.on((String)"|").join((Iterable)headerRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            }
        }
        if (!queryStringParameterRequirements.isEmpty()) {
            if (queryStringParameterRequirements.keySet().size() > 1) {
                for (Map.Entry queryStringParameterMatchEntry : queryStringParameterRequirements.entrySet()) {
                    httpRequest.withQueryStringParameter("?" + (String)queryStringParameterMatchEntry.getKey(), Joiner.on((String)"|").join((Iterable)queryStringParameterMatchEntry.getValue()));
                }
                httpRequest.withQueryStringParameter(Joiner.on((String)"|").join(queryStringParameterRequirements.keySet()), ".*");
            } else if (!headerRequirements.isEmpty() || !cookieRequirements.isEmpty()) {
                httpRequest.withQueryStringParameter("?" + Joiner.on((String)"|").join(queryStringParameterRequirements.keySet()), Joiner.on((String)"|").join((Iterable)queryStringParameterRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            } else {
                httpRequest.withQueryStringParameter(Joiner.on((String)"|").join(queryStringParameterRequirements.keySet()), Joiner.on((String)"|").join((Iterable)queryStringParameterRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            }
        }
        if (!cookieRequirements.isEmpty()) {
            if (cookieRequirements.keySet().size() > 1) {
                for (Map.Entry cookieMatchEntry : cookieRequirements.entrySet()) {
                    httpRequest.withCookie("?" + (String)cookieMatchEntry.getKey(), Joiner.on((String)"|").join((Iterable)cookieMatchEntry.getValue()));
                }
                httpRequest.withCookie(Joiner.on((String)"|").join(cookieRequirements.keySet()), ".*");
            } else if (!queryStringParameterRequirements.isEmpty() || !headerRequirements.isEmpty()) {
                httpRequest.withCookie("?" + Joiner.on((String)"|").join(cookieRequirements.keySet()), Joiner.on((String)"|").join((Iterable)cookieRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            } else {
                httpRequest.withCookie(Joiner.on((String)"|").join(cookieRequirements.keySet()), Joiner.on((String)"|").join((Iterable)cookieRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            }
        }
        return httpRequest;
    }

    private ParameterStyle parameterStyle(Boolean explode, Parameter.StyleEnum style) {
        ParameterStyle result = null;
        switch (style) {
            case MATRIX: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.MATRIX_EXPLODED;
                    break;
                }
                result = ParameterStyle.MATRIX;
                break;
            }
            case LABEL: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.LABEL_EXPLODED;
                    break;
                }
                result = ParameterStyle.LABEL;
                break;
            }
            case FORM: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.FORM_EXPLODED;
                    break;
                }
                result = ParameterStyle.FORM;
                break;
            }
            case SIMPLE: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.SIMPLE_EXPLODED;
                    break;
                }
                result = ParameterStyle.SIMPLE;
                break;
            }
            case SPACEDELIMITED: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.SPACE_DELIMITED_EXPLODED;
                    break;
                }
                result = ParameterStyle.SPACE_DELIMITED;
                break;
            }
            case PIPEDELIMITED: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.PIPE_DELIMITED_EXPLODED;
                    break;
                }
                result = ParameterStyle.PIPE_DELIMITED;
                break;
            }
            case DEEPOBJECT: {
                result = ParameterStyle.DEEP_OBJECT;
            }
        }
        return result;
    }

    private ParameterStyle parameterStyle(Boolean explode, Encoding.StyleEnum style) {
        ParameterStyle result = null;
        switch (style) {
            case FORM: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.FORM_EXPLODED;
                    break;
                }
                result = ParameterStyle.FORM;
                break;
            }
            case SPACE_DELIMITED: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.SPACE_DELIMITED_EXPLODED;
                    break;
                }
                result = ParameterStyle.SPACE_DELIMITED;
                break;
            }
            case PIPE_DELIMITED: {
                if (explode.booleanValue()) {
                    result = ParameterStyle.PIPE_DELIMITED_EXPLODED;
                    break;
                }
                result = ParameterStyle.PIPE_DELIMITED;
                break;
            }
            case DEEP_OBJECT: {
                result = ParameterStyle.DEEP_OBJECT;
            }
        }
        return result;
    }

    private void buildSecurityValues(OpenAPI openAPI, Map<String, Set<String>> headerRequirements, Map<String, Set<String>> queryStringParameterRequirements, Map<String, Set<String>> cookieRequirements, List<SecurityRequirement> security) {
        if (security != null) {
            for (SecurityRequirement securityRequirement : security) {
                if (securityRequirement == null) continue;
                for (String securityRequirementName : securityRequirement.keySet()) {
                    if (openAPI.getComponents() == null || openAPI.getComponents().getSecuritySchemes() == null || openAPI.getComponents().getSecuritySchemes().get(securityRequirementName) == null) continue;
                    SecurityScheme securityScheme = (SecurityScheme)openAPI.getComponents().getSecuritySchemes().get(securityRequirementName);
                    String scheme = securityScheme.getScheme();
                    block0 : switch (securityScheme.getType()) {
                        case APIKEY: {
                            String queryStringParameterValue;
                            Set<String> queryStringParameterValues;
                            String cookieValue;
                            Set<String> cookieValues;
                            String parameterName = securityScheme.getName();
                            if (!StringUtils.isNotBlank((CharSequence)parameterName)) break;
                            switch (securityScheme.getIn() != null ? securityScheme.getIn() : SecurityScheme.In.HEADER) {
                                case COOKIE: {
                                    cookieValues = cookieRequirements.get(parameterName);
                                    cookieValue = ".+";
                                    if (cookieValues != null) {
                                        cookieValues.add(cookieValue);
                                        break block0;
                                    }
                                    cookieRequirements.put(parameterName, new HashSet<String>(Collections.singletonList(cookieValue)));
                                    break block0;
                                }
                                case QUERY: {
                                    queryStringParameterValues = queryStringParameterRequirements.get(parameterName);
                                    queryStringParameterValue = ".+";
                                    if (queryStringParameterValues != null) {
                                        queryStringParameterValues.add(queryStringParameterValue);
                                        break block0;
                                    }
                                    queryStringParameterRequirements.put(parameterName, new HashSet<String>(Collections.singletonList(queryStringParameterValue)));
                                    break block0;
                                }
                            }
                            Set<String> headerValues = headerRequirements.get(parameterName);
                            String headerValue = ".+";
                            if (headerValues != null) {
                                headerValues.add(headerValue);
                                break;
                            }
                            headerRequirements.put(parameterName, new HashSet<String>(Collections.singletonList(headerValue)));
                            break;
                        }
                        case HTTP: 
                        case OAUTH2: 
                        case OPENIDCONNECT: {
                            String queryStringParameterValue;
                            Set<String> queryStringParameterValues;
                            String cookieValue;
                            Set<String> cookieValues;
                            String parameterName = HttpHeaderNames.AUTHORIZATION.toString();
                            switch (securityScheme.getIn() != null ? securityScheme.getIn() : SecurityScheme.In.HEADER) {
                                case COOKIE: {
                                    cookieValues = cookieRequirements.get(parameterName);
                                    cookieValue = (StringUtils.isNotBlank((CharSequence)scheme) ? scheme : "") + ".+";
                                    if (cookieValues != null) {
                                        cookieValues.add(cookieValue);
                                        break block0;
                                    }
                                    cookieRequirements.put(parameterName, new HashSet<String>(Collections.singletonList(cookieValue)));
                                    break block0;
                                }
                                case QUERY: {
                                    queryStringParameterValues = queryStringParameterRequirements.get(parameterName);
                                    queryStringParameterValue = (StringUtils.isNotBlank((CharSequence)scheme) ? scheme : "") + ".+";
                                    if (queryStringParameterValues != null) {
                                        queryStringParameterValues.add(queryStringParameterValue);
                                        break block0;
                                    }
                                    queryStringParameterRequirements.put(parameterName, new HashSet<String>(Collections.singletonList(queryStringParameterValue)));
                                    break block0;
                                }
                            }
                            Set<String> headerValues = headerRequirements.get(parameterName);
                            String headerValue = (StringUtils.isNotBlank((CharSequence)scheme) ? scheme : "") + ".+";
                            if (headerValues != null) {
                                headerValues.add(headerValue);
                                break;
                            }
                            headerRequirements.put(parameterName, new HashSet<String>(Collections.singletonList(headerValue)));
                            break;
                        }
                    }
                }
            }
        }
    }

    private BiConsumer<String, MediaType> handleRequestBody(OpenAPIDefinition openAPIDefinition, OpenAPI openAPI, String path, Pair<String, Operation> methodOperationPair, Boolean required, List<LogEntry> logEntries) {
        return (contentType, mediaType) -> {
            HttpRequest httpRequest = this.createHttpRequest(openAPIDefinition, openAPI, path, methodOperationPair);
            if (contentType.equals("multipart/form-data")) {
                logEntries.add(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("multipart form data is not supported on requestBody, skipping operation:{}method:{}in open api:{}").setArguments(((Operation)methodOperationPair.getRight()).getOperationId(), methodOperationPair.getLeft(), openAPIDefinition));
                return;
            }
            if (!contentType.equals("*/*") && required.booleanValue()) {
                httpRequest.withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), contentType.replaceAll("\\*", ".*") + ".*");
            }
            if (mediaType != null && mediaType.getSchema() != null) {
                HashMap<String, ParameterStyle> parameterStyle = null;
                if (mediaType.getEncoding() != null) {
                    parameterStyle = new HashMap<String, ParameterStyle>();
                    for (Map.Entry encodingEntry : mediaType.getEncoding().entrySet()) {
                        parameterStyle.put((String)encodingEntry.getKey(), this.parameterStyle(((Encoding)encodingEntry.getValue()).getExplode(), ((Encoding)encodingEntry.getValue()).getStyle()));
                    }
                }
                try {
                    httpRequest.withBody(JsonSchemaBody.jsonSchema(OBJECT_WRITER.writeValueAsString((Object)mediaType.getSchema())).withParameterStyles(parameterStyle).withOptional(required == false));
                }
                catch (Throwable throwable) {
                    logEntries.add(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while creating adding request body{} for operation:{}method:{}in open api:{}").setArguments(mediaType.getSchema(), ((Operation)methodOperationPair.getRight()).getOperationId(), methodOperationPair.getLeft(), openAPIDefinition));
                }
            }
            try {
                this.addRequestMatcher(openAPIDefinition, methodOperationPair, httpRequest, (String)contentType);
            }
            catch (Throwable throwable) {
                logEntries.add(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while creating adding request matcher for operation:{}method:{}in open api:{}").setArguments(((Operation)methodOperationPair.getRight()).getOperationId(), methodOperationPair.getLeft(), openAPIDefinition));
            }
        };
    }

    private void addRequestMatcher(OpenAPIDefinition openAPIDefinition, Pair<String, Operation> methodOperationPair, HttpRequest httpRequest, String contentType) {
        this.httpRequests.add(httpRequest);
        HttpRequestPropertiesMatcher httpRequestPropertiesMatcher = new HttpRequestPropertiesMatcher(this.configuration, this.mockServerLogger);
        httpRequestPropertiesMatcher.update(httpRequest);
        httpRequestPropertiesMatcher.setControlPlaneMatcher(this.controlPlaneMatcher);
        int maxUrlOrPathLength = 40;
        int urlOrPathLength = openAPIDefinition.getSpecUrlOrPayload().length();
        String urlOrPath = (urlOrPathLength > maxUrlOrPathLength ? "..." : "") + openAPIDefinition.getSpecUrlOrPayload().substring(urlOrPathLength > maxUrlOrPathLength ? urlOrPathLength - maxUrlOrPathLength : urlOrPathLength);
        httpRequestPropertiesMatcher.setDescription(" open api" + (openAPIDefinition.getSpecUrlOrPayload().endsWith(".json") || openAPIDefinition.getSpecUrlOrPayload().endsWith(".yaml") ? " \"" + urlOrPath + "\"" : "") + (StringUtils.isNotBlank((CharSequence)((Operation)methodOperationPair.getValue()).getOperationId()) ? " operation \"" + ((Operation)methodOperationPair.getValue()).getOperationId() + "\"" : "") + (StringUtils.isNotBlank((CharSequence)contentType) ? " content-type \"" + contentType + "\"" : ""));
        this.httpRequestPropertiesMatchers.add(httpRequestPropertiesMatcher);
    }

    @Override
    public boolean matches(MatchDifference context, RequestDefinition requestDefinition) {
        boolean result = false;
        if (this.httpRequestPropertiesMatchers != null && !this.httpRequestPropertiesMatchers.isEmpty()) {
            for (HttpRequestPropertiesMatcher httpRequestPropertiesMatcher : this.httpRequestPropertiesMatchers) {
                if (context == null) {
                    if (MockServerLogger.isEnabled(Level.TRACE) && requestDefinition instanceof HttpRequest) {
                        context = new MatchDifference(this.configuration.detailedMatchFailures(), requestDefinition);
                    }
                    result = httpRequestPropertiesMatcher.matches(context, requestDefinition);
                } else {
                    MatchDifference singleMatchDifference = new MatchDifference(this.configuration.detailedMatchFailures(), context.getHttpRequest());
                    result = httpRequestPropertiesMatcher.matches(singleMatchDifference, requestDefinition);
                    context.addDifferences(singleMatchDifference.getAllDifferences());
                }
                if (!result) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return TO_STRING_OBJECT_WRITER.writeValueAsString((Object)this.openAPIDefinition);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequestsPropertiesMatcher that = (HttpRequestsPropertiesMatcher)o;
        return Objects.equals(this.openAPIDefinition, that.openAPIDefinition);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.openAPIDefinition);
        }
        return this.hashCode;
    }
}

