/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.file;

import java.io.File;
import java.io.IOException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class FileCreator {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(FileCreator.class);

    public static File createFileIfNotExists(String type, File file) {
        if (!file.exists()) {
            try {
                FileCreator.createParentDirs(file);
                if (!file.createNewFile()) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save " + type + " file").setArguments(file.getAbsolutePath()));
                }
            }
            catch (Throwable throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save " + type + " file").setArguments(file.getAbsolutePath()).setThrowable(throwable));
            }
        }
        return file;
    }

    public static void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        FileCreator.createParentDirs(parent);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }
}

