/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine;

import com.google.common.collect.ImmutableMap;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.time.TimeService;
import org.mockserver.uuid.UUIDService;

public class TemplateFunctions
implements Supplier<Object> {
    private static final Random random = new Random();
    private static final Base64Converter base64Converter = new Base64Converter();
    public static final Map<String, Supplier<Object>> BUILT_IN_FUNCTIONS = ImmutableMap.builder().put((Object)"now", (Object)new TemplateFunctions(() -> DateTimeFormatter.ISO_INSTANT.format(TimeService.now()))).put((Object)"now_epoch", (Object)new TemplateFunctions(() -> String.valueOf(TimeService.now().getEpochSecond()))).put((Object)"now_iso_8601", (Object)new TemplateFunctions(() -> DateTimeFormatter.ISO_INSTANT.format(TimeService.now()))).put((Object)"now_rfc_1123", (Object)new TemplateFunctions(() -> DateTimeFormatter.RFC_1123_DATE_TIME.format(TimeService.offsetNow()))).put((Object)"uuid", (Object)new TemplateFunctions(UUIDService::getUUID)).put((Object)"rand_int", (Object)new TemplateFunctions(() -> TemplateFunctions.randomInteger(10))).put((Object)"rand_int_10", (Object)new TemplateFunctions(() -> TemplateFunctions.randomInteger(10))).put((Object)"rand_int_100", (Object)new TemplateFunctions(() -> TemplateFunctions.randomInteger(100))).put((Object)"rand_bytes", (Object)new TemplateFunctions(() -> TemplateFunctions.randomBytes(16))).put((Object)"rand_bytes_16", (Object)new TemplateFunctions(() -> TemplateFunctions.randomBytes(16))).put((Object)"rand_bytes_32", (Object)new TemplateFunctions(() -> TemplateFunctions.randomBytes(32))).put((Object)"rand_bytes_64", (Object)new TemplateFunctions(() -> TemplateFunctions.randomBytes(64))).put((Object)"rand_bytes_128", (Object)new TemplateFunctions(() -> TemplateFunctions.randomBytes(128))).build();
    private final Supplier<String> supplier;

    public TemplateFunctions(Supplier<String> supplier) {
        this.supplier = supplier;
    }

    public static String randomInteger(int max) {
        return String.valueOf(random.nextInt(max));
    }

    public static String randomBytes(int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return String.valueOf(base64Converter.bytesToBase64String(bytes));
    }

    @Override
    public Object get() {
        return this.supplier.get();
    }

    public String toString() {
        return this.supplier.get();
    }
}

